/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.tasks.FileExistComportment;
import io.kestra.core.runners.WorkingDir;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.PathMatcherPredicate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWorkingDir
implements WorkingDir {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalWorkingDir.class);
    private final Path workingDirPath;
    private final String workingDirId;

    public LocalWorkingDir(Path tmpdirBasePath) {
        this(tmpdirBasePath, IdUtils.create());
    }

    public LocalWorkingDir(Path tmpdirBasePath, String workingDirId) {
        this.workingDirId = workingDirId;
        this.workingDirPath = tmpdirBasePath.resolve(workingDirId);
    }

    @Override
    public Path path() {
        return this.path(true);
    }

    @Override
    public String id() {
        return this.workingDirId;
    }

    @Override
    public synchronized Path path(boolean create) {
        if (create && !this.workingDirPath.toFile().exists()) {
            this.workingDirPath.toFile().mkdirs();
        }
        return this.workingDirPath;
    }

    @Override
    public Path resolve(Path path) {
        if (path == null) {
            return this.path();
        }
        if (path.toString().contains(".." + File.separator)) {
            throw new IllegalArgumentException("The path to resolve must be a relative path inside the current working directory.");
        }
        Path baseDir = this.path();
        Path resolved = baseDir.resolve(path).toAbsolutePath();
        if (!resolved.startsWith(baseDir)) {
            throw new IllegalArgumentException("The path to resolve must be a relative path inside the current working directory.");
        }
        return resolved;
    }

    @Override
    public Path createTempFile() throws IOException {
        return this.createTempFile(null, null);
    }

    @Override
    public Path createTempFile(String extension) throws IOException {
        return this.createTempFile(null, extension);
    }

    @Override
    public Path createTempFile(byte[] content) throws IOException {
        return this.createTempFile(content, null);
    }

    @Override
    public Path createTempFile(byte[] content, String extension) throws IOException {
        String suffix = extension != null && !extension.startsWith(".") ? "." + extension : extension;
        Path tempFile = Files.createTempFile(this.path(), null, suffix, new FileAttribute[0]);
        if (content != null) {
            Files.write(tempFile, content, new OpenOption[0]);
        }
        return tempFile;
    }

    @Override
    public Path createFile(String filename) throws IOException {
        return this.createFile(filename, (InputStream)null);
    }

    @Override
    public Path createFile(String filename, byte[] content) throws IOException {
        return this.createFile(filename, content == null ? null : new ByteArrayInputStream(content));
    }

    @Override
    public Path createFile(String filename, InputStream content) throws IOException {
        if (filename == null || filename.isBlank()) {
            throw new IllegalArgumentException("Cannot create a working directory file with a null or empty name");
        }
        Path newFilePath = this.resolve(Path.of(filename, new String[0]));
        Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
        Files.createFile(newFilePath, new FileAttribute[0]);
        if (content != null) {
            try (InputStream inputStream = content;){
                Files.copy(content, newFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return newFilePath;
    }

    @Override
    public Path putFile(Path path, InputStream inputStream) throws IOException {
        return this.putFile(path, inputStream, FileExistComportment.OVERWRITE);
    }

    @Override
    public Path putFile(Path path, InputStream inputStream, FileExistComportment comportment) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Cannot create a working directory file with a null path");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot create a working directory file with an empty inputStream");
        }
        Path newFilePath = this.resolve(path);
        Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
        if (Files.exists(newFilePath, new LinkOption[0])) {
            switch (comportment) {
                case OVERWRITE: {
                    log.info("File {} already exist. It will be overwritten", (Object)newFilePath);
                    LocalWorkingDir.copyFile(inputStream, newFilePath);
                    break;
                }
                case FAIL: {
                    throw new FileAlreadyExistsException("File " + String.valueOf(newFilePath) + " already exist");
                }
                case WARN: {
                    log.warn("File {} already exist. It will be ignore", (Object)newFilePath);
                    break;
                }
            }
        } else {
            Files.createFile(newFilePath, new FileAttribute[0]);
            LocalWorkingDir.copyFile(inputStream, newFilePath);
        }
        return newFilePath;
    }

    private static void copyFile(InputStream inputStream, Path path) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public List<Path> findAllFilesMatching(List<String> patterns) throws IOException {
        if (patterns == null || patterns.isEmpty()) {
            return Collections.emptyList();
        }
        MatcherFileVisitor visitor = new MatcherFileVisitor(PathMatcherPredicate.matches(this.path(), patterns));
        Files.walkFileTree(this.path(), visitor);
        return visitor.getMatchedFiles();
    }

    @Override
    public void cleanup() throws IOException {
        if (this.workingDirPath != null && Files.exists(this.workingDirPath, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)this.workingDirPath.toFile());
        }
    }

    private static class MatcherFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Predicate<Path> predicate;
        private final List<Path> matchedFiles = new ArrayList<Path>();

        public MatcherFileVisitor(Predicate<Path> predicate) {
            this.predicate = predicate;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            if (!basicFileAttributes.isRegularFile()) {
                return FileVisitResult.CONTINUE;
            }
            if (this.predicate.test(path)) {
                this.matchedFiles.add(path);
            }
            return FileVisitResult.CONTINUE;
        }

        public List<Path> getMatchedFiles() {
            return this.matchedFiles;
        }
    }
}

