/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@Singleton
public class RunContextCache {
    @Value(value="${kestra.variables.redacted-env-vars:KESTRA_PLUGINS_PATH,KESTRA_CONFIGURATION_PATH,KESTRA_CONFIGURATION,KESTRA_JAVA_OPTS}")
    private List<String> redactedEnvVar;
    @Inject
    private ApplicationContext applicationContext;
    private Map<?, ?> globalVars = null;
    private Map<String, String> envVars = null;

    @PostConstruct
    void init() {
        String envPrefix = (String)this.applicationContext.getProperty("kestra.variables.env-vars-prefix", String.class, (Object)"ENV_");
        this.envVars = this.envVariables(envPrefix);
        this.globalVars = this.applicationContext.getProperty("kestra.variables.globals", Map.class).orElseGet(Map::of);
    }

    private Map<String, String> envVariables(String envPrefix) {
        HashMap<String, String> result = new HashMap<String, String>(System.getenv());
        result.putAll(System.getProperties());
        return result.entrySet().stream().filter(e -> !this.redactedEnvVar.contains(e.getKey()) && ((String)e.getKey()).startsWith(envPrefix)).map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(envPrefix.length()).toLowerCase(), (String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    public Map<?, ?> getGlobalVars() {
        return this.globalVars;
    }

    @Generated
    public Map<String, String> getEnvVars() {
        return this.envVars;
    }
}

