/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.encryption.EncryptionService;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;

final class Secret {
    private final Optional<String> secretKey;
    private final Supplier<Logger> logger;

    Secret(Optional<String> secretKey, Supplier<Logger> logger) {
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey cannot be null");
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
    }

    String decrypt(String encrypted) throws GeneralSecurityException {
        if (this.secretKey.isPresent()) {
            return EncryptionService.decrypt(this.secretKey.get(), encrypted);
        }
        this.logger.get().warn("Unable to decrypt the output as encryption is not configured");
        return encrypted;
    }

    String encrypt(String plaintext) throws GeneralSecurityException {
        if (this.secretKey.isPresent()) {
            return EncryptionService.encrypt(this.secretKey.get(), plaintext);
        }
        this.logger.get().warn("Unable to encrypt the output as encryption is not configured");
        return plaintext;
    }

    Map<String, Object> decrypt(Map<String, Object> data) {
        HashMap<String, Object> decryptedMap = new HashMap<String, Object>(data);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String typeStr;
            Object object = entry.getValue();
            if (!(object instanceof Map)) continue;
            Map map = (Map)object;
            Object v = map.get("type");
            if (v instanceof String && "io.kestra.datatype:aes_encrypted".equalsIgnoreCase(typeStr = (String)v)) {
                try {
                    String decoded = this.decrypt((String)map.get("value"));
                    decryptedMap.put(entry.getKey(), decoded);
                }
                catch (IllegalArgumentException | GeneralSecurityException e) {
                    this.logger.get().warn("Unable to decrypt the output", (Throwable)e);
                }
                continue;
            }
            decryptedMap.put(entry.getKey(), this.decrypt(map));
        }
        return decryptedMap;
    }
}

