/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import io.kestra.core.runners.pebble.expression.InExpression;
import io.kestra.core.runners.pebble.expression.NullCoalescingExpression;
import io.kestra.core.runners.pebble.expression.UndefinedCoalescingExpression;
import io.kestra.core.runners.pebble.filters.ChunkFilter;
import io.kestra.core.runners.pebble.filters.ClassNameFilter;
import io.kestra.core.runners.pebble.filters.DateAddFilter;
import io.kestra.core.runners.pebble.filters.DateFilter;
import io.kestra.core.runners.pebble.filters.DistinctFilter;
import io.kestra.core.runners.pebble.filters.EndsWithFilter;
import io.kestra.core.runners.pebble.filters.EscapeCharFilter;
import io.kestra.core.runners.pebble.filters.FlattenFilter;
import io.kestra.core.runners.pebble.filters.IndentFilter;
import io.kestra.core.runners.pebble.filters.JqFilter;
import io.kestra.core.runners.pebble.filters.JsonFilter;
import io.kestra.core.runners.pebble.filters.KeysFilter;
import io.kestra.core.runners.pebble.filters.Md5Filter;
import io.kestra.core.runners.pebble.filters.NindentFilter;
import io.kestra.core.runners.pebble.filters.NumberFilter;
import io.kestra.core.runners.pebble.filters.Sha1Filter;
import io.kestra.core.runners.pebble.filters.Sha512Filter;
import io.kestra.core.runners.pebble.filters.SlugifyFilter;
import io.kestra.core.runners.pebble.filters.StartsWithFilter;
import io.kestra.core.runners.pebble.filters.StringFilter;
import io.kestra.core.runners.pebble.filters.SubstringAfterFilter;
import io.kestra.core.runners.pebble.filters.SubstringAfterLastFilter;
import io.kestra.core.runners.pebble.filters.SubstringBeforeFilter;
import io.kestra.core.runners.pebble.filters.SubstringBeforeLastFilter;
import io.kestra.core.runners.pebble.filters.TimestampFilter;
import io.kestra.core.runners.pebble.filters.TimestampMicroFilter;
import io.kestra.core.runners.pebble.filters.TimestampMilliFilter;
import io.kestra.core.runners.pebble.filters.TimestampNanoFilter;
import io.kestra.core.runners.pebble.filters.ToIonFilter;
import io.kestra.core.runners.pebble.filters.ToJsonFilter;
import io.kestra.core.runners.pebble.filters.UrlDecoderFilter;
import io.kestra.core.runners.pebble.filters.ValuesFilter;
import io.kestra.core.runners.pebble.filters.YamlFilter;
import io.kestra.core.runners.pebble.functions.CurrentEachOutputFunction;
import io.kestra.core.runners.pebble.functions.DecryptFunction;
import io.kestra.core.runners.pebble.functions.EncryptFunction;
import io.kestra.core.runners.pebble.functions.ErrorLogsFunction;
import io.kestra.core.runners.pebble.functions.FetchContextFunction;
import io.kestra.core.runners.pebble.functions.FileExistsFunction;
import io.kestra.core.runners.pebble.functions.FileSizeFunction;
import io.kestra.core.runners.pebble.functions.FileURIFunction;
import io.kestra.core.runners.pebble.functions.FromIonFunction;
import io.kestra.core.runners.pebble.functions.FromJsonFunction;
import io.kestra.core.runners.pebble.functions.HttpFunction;
import io.kestra.core.runners.pebble.functions.IDFunction;
import io.kestra.core.runners.pebble.functions.IsFileEmptyFunction;
import io.kestra.core.runners.pebble.functions.JsonFunction;
import io.kestra.core.runners.pebble.functions.KSUIDFunction;
import io.kestra.core.runners.pebble.functions.KvFunction;
import io.kestra.core.runners.pebble.functions.NowFunction;
import io.kestra.core.runners.pebble.functions.RandomIntFunction;
import io.kestra.core.runners.pebble.functions.RandomPortFunction;
import io.kestra.core.runners.pebble.functions.ReadFileFunction;
import io.kestra.core.runners.pebble.functions.RenderFunction;
import io.kestra.core.runners.pebble.functions.RenderOnceFunction;
import io.kestra.core.runners.pebble.functions.SecretFunction;
import io.kestra.core.runners.pebble.functions.TasksWithStateFunction;
import io.kestra.core.runners.pebble.functions.UUIDFunction;
import io.kestra.core.runners.pebble.functions.YamlFunction;
import io.kestra.core.runners.pebble.tests.JsonTest;
import io.micronaut.core.annotation.Nullable;
import io.pebbletemplates.pebble.extension.AbstractExtension;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.extension.NodeVisitorFactory;
import io.pebbletemplates.pebble.extension.Test;
import io.pebbletemplates.pebble.operator.Associativity;
import io.pebbletemplates.pebble.operator.BinaryOperator;
import io.pebbletemplates.pebble.operator.BinaryOperatorImpl;
import io.pebbletemplates.pebble.operator.BinaryOperatorType;
import io.pebbletemplates.pebble.operator.UnaryOperator;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class Extension
extends AbstractExtension {
    @Inject
    private SecretFunction secretFunction;
    @Inject
    private KvFunction kvFunction;
    @Inject
    private ReadFileFunction readFileFunction;
    @Inject
    private FileURIFunction fileURIFunction;
    @Inject
    @Nullable
    private RenderFunction renderFunction;
    @Inject
    @Nullable
    private RenderOnceFunction renderOnceFunction;
    @Inject
    private FileSizeFunction fileSizeFunction;
    @Inject
    private IsFileEmptyFunction isFileEmptyFunction;
    @Inject
    private FileExistsFunction fileExistsFunction;
    @Inject
    @Nullable
    private ErrorLogsFunction errorLogsFunction;
    @Inject
    private HttpFunction httpFunction;

    public List<TokenParser> getTokenParsers() {
        return null;
    }

    public List<UnaryOperator> getUnaryOperators() {
        return null;
    }

    public List<BinaryOperator> getBinaryOperators() {
        ArrayList<BinaryOperator> operators = new ArrayList<BinaryOperator>();
        operators.add((BinaryOperator)new BinaryOperatorImpl("??", 120, NullCoalescingExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add((BinaryOperator)new BinaryOperatorImpl("???", 120, UndefinedCoalescingExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        operators.add((BinaryOperator)new BinaryOperatorImpl("isIn", 120, InExpression::new, BinaryOperatorType.NORMAL, Associativity.LEFT));
        return operators;
    }

    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("chunk", new ChunkFilter());
        filters.put("className", new ClassNameFilter());
        filters.put("date", new DateFilter());
        filters.put("dateAdd", new DateAddFilter());
        filters.put("timestamp", new TimestampFilter());
        filters.put("timestampMicro", new TimestampMicroFilter());
        filters.put("timestampMilli", new TimestampMilliFilter());
        filters.put("timestampNano", new TimestampNanoFilter());
        filters.put("jq", new JqFilter());
        filters.put("escapeChar", new EscapeCharFilter());
        filters.put("json", new JsonFilter());
        filters.put("toJson", new ToJsonFilter());
        filters.put("distinct", new DistinctFilter());
        filters.put("keys", new KeysFilter());
        filters.put("number", new NumberFilter());
        filters.put("urldecode", new UrlDecoderFilter());
        filters.put("slugify", new SlugifyFilter());
        filters.put("substringBefore", new SubstringBeforeFilter());
        filters.put("substringBeforeLast", new SubstringBeforeLastFilter());
        filters.put("substringAfter", new SubstringAfterFilter());
        filters.put("substringAfterLast", new SubstringAfterLastFilter());
        filters.put("flatten", new FlattenFilter());
        filters.put("indent", new IndentFilter());
        filters.put("nindent", new NindentFilter());
        filters.put("yaml", new YamlFilter());
        filters.put("startsWith", new StartsWithFilter());
        filters.put("endsWith", new EndsWithFilter());
        filters.put("values", new ValuesFilter());
        filters.put("toIon", new ToIonFilter());
        filters.put("sha1", new Sha1Filter());
        filters.put("sha512", new Sha512Filter());
        filters.put("md5", new Md5Filter());
        filters.put("string", new StringFilter());
        return filters;
    }

    public Map<String, Test> getTests() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        tests.put("json", new JsonTest());
        return tests;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("now", new NowFunction());
        functions.put("json", new JsonFunction());
        functions.put("fromJson", new FromJsonFunction());
        functions.put("currentEachOutput", new CurrentEachOutputFunction());
        functions.put("secret", this.secretFunction);
        functions.put("kv", this.kvFunction);
        functions.put("read", this.readFileFunction);
        functions.put("fileURI", this.fileURIFunction);
        if (this.renderFunction != null) {
            functions.put(this.renderFunction.functionName(), this.renderFunction);
        }
        if (this.renderOnceFunction != null) {
            functions.put(this.renderOnceFunction.functionName(), this.renderOnceFunction);
        }
        functions.put("encrypt", new EncryptFunction());
        functions.put("decrypt", new DecryptFunction());
        functions.put("yaml", new YamlFunction());
        functions.put("printContext", new FetchContextFunction());
        functions.put("fetchContext", new FetchContextFunction());
        functions.put("uuid", new UUIDFunction());
        functions.put("id", new IDFunction());
        functions.put("ksuid", new KSUIDFunction());
        functions.put("fromIon", new FromIonFunction());
        functions.put("fileSize", this.fileSizeFunction);
        if (this.errorLogsFunction != null) {
            functions.put("errorLogs", this.errorLogsFunction);
        }
        functions.put("randomInt", new RandomIntFunction());
        functions.put("randomPort", new RandomPortFunction());
        functions.put("fileExists", this.fileExistsFunction);
        functions.put("isFileEmpty", this.isFileEmptyFunction);
        functions.put("tasksWithState", new TasksWithStateFunction());
        functions.put("http", this.httpFunction);
        return functions;
    }

    public Map<String, Object> getGlobalVariables() {
        return null;
    }

    public List<NodeVisitorFactory> getNodeVisitors() {
        return null;
    }
}

