/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.utils.Enums;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapeCharFilter
implements Filter {
    private static final String ARG_NAME = "type";
    private final List<String> argumentNames = new ArrayList<String>();

    public EscapeCharFilter() {
        this.argumentNames.add(ARG_NAME);
    }

    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (input instanceof Map) {
            return this.processMap((Map)input, args, self, lineNumber);
        }
        if (input instanceof List) {
            return this.processList((List)input, args, self, lineNumber);
        }
        return this.escapeString(input.toString(), args, self, lineNumber);
    }

    private Object processMap(Map<String, Object> inputMap, Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = (String)value;
                resultMap.put(entry.getKey(), this.escapeString(stringValue, args, self, lineNumber));
                continue;
            }
            if (value instanceof Map) {
                resultMap.put(entry.getKey(), this.processMap((Map)value, args, self, lineNumber));
                continue;
            }
            if (value instanceof List) {
                resultMap.put(entry.getKey(), this.processList((List)value, args, self, lineNumber));
                continue;
            }
            resultMap.put(entry.getKey(), this.escapeString(value.toString(), args, self, lineNumber));
        }
        return resultMap;
    }

    private Object processList(List<Object> inputList, Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object item : inputList) {
            if (item instanceof String) {
                String stringValue = (String)item;
                resultList.add(this.escapeString(stringValue, args, self, lineNumber));
                continue;
            }
            if (item instanceof Map) {
                resultList.add(this.processMap((Map)item, args, self, lineNumber));
                continue;
            }
            if (item instanceof List) {
                resultList.add(this.processList((List)item, args, self, lineNumber));
                continue;
            }
            resultList.add(this.escapeString(item.toString(), args, self, lineNumber));
        }
        return resultList;
    }

    private String escapeString(String input, Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        return switch (this.argsToType(args, self, lineNumber).ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> this.escape(input, "'", "'\\''");
            case 0 -> this.escape(input, "'", "\\'");
            case 1 -> this.escape(input, "\"", "\\\"");
        };
    }

    private FilterType argsToType(Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        if (!args.containsKey(ARG_NAME)) {
            throw new PebbleException(null, "The 'escapeChar' filter expects an argument 'type'.", Integer.valueOf(lineNumber), self.getName());
        }
        String type = (String)args.get(ARG_NAME);
        try {
            return Enums.getForNameIgnoreCase(type, FilterType.class);
        }
        catch (IllegalArgumentException e) {
            throw new PebbleException(null, "The 'escapeChar' filter expects the value of 'type' to be either 'single', 'double', or 'shell'.", Integer.valueOf(lineNumber), self.getName());
        }
    }

    private String escape(String input, String original, String replacement) {
        return input.replace(original, replacement);
    }

    static enum FilterType {
        SINGLE,
        DOUBLE,
        SHELL;

    }
}

