/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.runners.pebble.PebbleUtils;
import io.kestra.core.services.LogService;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.RetryUtils;
import io.micronaut.context.annotation.Requires;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Singleton
@Requires(property="kestra.repository.type")
public class ErrorLogsFunction
implements Function {
    @Inject
    private LogService logService;
    @Inject
    private PebbleUtils pebbleUtils;
    @Inject
    private RetryUtils retryUtils;

    public List<String> getArgumentNames() {
        return Collections.emptyList();
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!this.pebbleUtils.calledOnWorker()) {
            throw new PebbleException(null, "The 'errorLogs' function can only be used in the Worker as it access logs from the database.", Integer.valueOf(lineNumber), self.getName());
        }
        Map flow = (Map)context.getVariable("flow");
        Map execution = (Map)context.getVariable("execution");
        RetryUtils.Instance retry = this.retryUtils.of(((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)((AbstractRetry.AbstractRetryBuilder)((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)Exponential.builder().delayFactor(2.0)).interval(Duration.ofMillis(100L))).maxInterval(Duration.ofSeconds(1L))).maxAttempts(-1)).maxDuration(Duration.ofSeconds(5L))).build());
        try {
            return retry.run(logs -> ListUtils.isEmpty(logs), () -> this.logService.errorLogs((String)flow.get("tenantId"), (String)execution.get("id")));
        }
        catch (RetryUtils.RetryFailed e) {
            return Collections.emptyList();
        }
        catch (Throwable e) {
            throw new PebbleException(e, "Unable to fetch error logs");
        }
    }
}

