/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.runners.pebble.functions.AbstractFileFunction;
import io.kestra.core.storages.FileAttributes;
import io.pebbletemplates.pebble.template.EvaluationContext;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.attribute.BasicFileAttributes;

@Singleton
public class FileSizeFunction
extends AbstractFileFunction {
    private static final String ERROR_MESSAGE = "The 'fileSize' function expects an argument 'path' that is a path to the internal storage URI.";

    @Override
    protected Object fileFunction(EvaluationContext context, URI path, String namespace, String tenantId) throws IOException {
        return switch (path.getScheme()) {
            case "kestra" -> {
                FileAttributes fileAttributes = this.storageInterface.getAttributes(tenantId, namespace, path);
                yield fileAttributes.getSize();
            }
            case "file" -> {
                BasicFileAttributes fileAttributes = this.localPathFactory.createLocalPath().getAttributes(path);
                yield fileAttributes.size();
            }
            default -> throw new IllegalArgumentException("Cannot process the URI %s: scheme not supported.".formatted(path));
        };
    }

    @Override
    protected String getErrorMessage() {
        return ERROR_MESSAGE;
    }
}

