/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.runners.pebble.functions.AbstractFileFunction;
import io.pebbletemplates.pebble.template.EvaluationContext;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

@Singleton
public class IsFileEmptyFunction
extends AbstractFileFunction {
    private static final String ERROR_MESSAGE = "The 'isFileEmpty' function expects an argument 'path' that is a path to a namespace file or an internal storage URI.";

    @Override
    protected Object fileFunction(EvaluationContext context, URI path, String namespace, String tenantId) throws IOException {
        Boolean bl;
        switch (path.getScheme()) {
            case "kestra": {
                try (InputStream inputStream = this.storageInterface.get(tenantId, namespace, path);){
                    byte[] buffer = new byte[1];
                    Boolean bl2 = inputStream.read(buffer, 0, 1) <= 0;
                    bl = bl2;
                    break;
                }
            }
            case "file": {
                try (InputStream inputStream = this.localPathFactory.createLocalPath().get(path);){
                    byte[] buffer = new byte[1];
                    Boolean bl3 = inputStream.read(buffer, 0, 1) <= 0;
                    bl = bl3;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Cannot process the URI %s: scheme not supported.".formatted(path));
            }
        }
        return bl;
    }

    @Override
    protected String getErrorMessage() {
        return ERROR_MESSAGE;
    }
}

