/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.server.ServerConfig;
import io.kestra.core.utils.ExecutorsUtils;
import io.micronaut.core.annotation.Introspected;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public abstract class AbstractServiceLivenessTask
implements Runnable,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractServiceLivenessTask.class);
    private final String name;
    protected final ServerConfig serverConfig;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> scheduledFuture;
    private Instant lastScheduledExecution;

    protected AbstractServiceLivenessTask(String name, ServerConfig configuration) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.serverConfig = Objects.requireNonNull(configuration, "serverConfig cannot be null");
        this.lastScheduledExecution = Instant.now();
    }

    @Override
    public void run() {
        if (!this.isStopped.get()) {
            this.run(Instant.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void run(Instant now) {
        try {
            long elapsed = this.getElapsedMilliSinceLastSchedule(now);
            long timeout = this.serverConfig.liveness().timeout().toMillis();
            if (elapsed > timeout + timeout / 10L) {
                log.warn("Thread starvation or clock leap detected (elapsed since previous schedule {}ms", (Object)elapsed);
            }
            this.onSchedule(now);
        }
        catch (Exception e) {
            log.error("Unexpected error while executing '{}'. Error: {}", new Object[]{this.name, e.getMessage(), e});
        }
        finally {
            this.lastScheduledExecution = now;
        }
    }

    protected Instant lastScheduledExecution() {
        return this.lastScheduledExecution;
    }

    protected long getElapsedMilliSinceLastSchedule(Instant now) {
        return now.toEpochMilli() - this.lastScheduledExecution.toEpochMilli();
    }

    protected abstract void onSchedule(Instant var1) throws Exception;

    @PostConstruct
    public void start() {
        if (!this.isLivenessEnabled().booleanValue()) {
            log.warn("Server liveness is disabled (kestra.server.liveness.enabled=false) If you are running in production environment, please ensure this property is configured to 'true'.");
        }
        if (this.scheduledExecutorService != null || this.isStopped.get()) {
            throw new IllegalStateException("The task '" + this.name + "' is either already started or already stopped, cannot re-start");
        }
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, this.name));
        Duration scheduleInterval = this.getScheduleInterval();
        log.debug("Scheduling '{}' at fixed rate {}.", (Object)this.name, (Object)scheduleInterval);
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this, 0L, scheduleInterval.toSeconds(), TimeUnit.SECONDS);
    }

    protected Boolean isLivenessEnabled() {
        return this.serverConfig.liveness().enabled();
    }

    protected abstract Duration getScheduleInterval();

    @Override
    @PreDestroy
    public void close() {
        if (this.isStopped.compareAndSet(false, true) && this.scheduledExecutorService != null) {
            ExecutorsUtils.closeScheduledThreadPool(this.scheduledExecutorService, Duration.ofSeconds(5L), List.of(this.scheduledFuture));
        }
    }
}

