/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceStateTransition {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceStateTransition.class);

    public static Response maybeTransitionServiceState(@Nullable ServiceInstance from, ServiceInstance to, Service.ServiceState newState, String reason) {
        if (from == null) {
            return ServiceStateTransition.logTransitionAndGetResponse(to, newState, null);
        }
        if (from.state().isValidTransition(newState)) {
            ServiceInstance updated = from.state(newState, Instant.now(), reason).server(to.server()).metrics(to.metrics());
            return ServiceStateTransition.logTransitionAndGetResponse(to, newState, (ImmutablePair<ServiceInstance, ServiceInstance>)new ImmutablePair((Object)from, (Object)updated));
        }
        return ServiceStateTransition.logTransitionAndGetResponse(to, newState, (ImmutablePair<ServiceInstance, ServiceInstance>)new ImmutablePair((Object)from, null));
    }

    public static Response logTransitionAndGetResponse(@NotNull ServiceInstance initial, @NotNull Service.ServiceState newState, @Nullable ImmutablePair<ServiceInstance, ServiceInstance> result) {
        if (result == null) {
            LOG.debug("Failed to transition service [id={}, type={}, hostname={}] to {}. Cause: {}", new Object[]{initial.uid(), initial.type(), initial.server().hostname(), newState, "Invalid service."});
            return new Response(Result.ABORTED);
        }
        ServiceInstance oldInstance = (ServiceInstance)result.getLeft();
        ServiceInstance newInstance = (ServiceInstance)result.getRight();
        if (newInstance == null) {
            LOG.warn("Failed to transition service [id={}, type={}, hostname={}] from {} to {}. Cause: {}.", new Object[]{initial.uid(), initial.type(), initial.server().hostname(), oldInstance.state(), newState, "Invalid transition"});
            return new Response(Result.FAILED, oldInstance);
        }
        if (!oldInstance.state().equals((Object)newInstance.state()) && LOG.isDebugEnabled()) {
            LOG.debug("Service [id={}, type={}, hostname={}] transition from {} to {}.", new Object[]{initial.uid(), initial.type(), initial.server().hostname(), oldInstance.state(), newInstance.state()});
        }
        return new Response(Result.SUCCEEDED, newInstance);
    }

    public record Response(Result result, @Nullable ServiceInstance instance) {
        public Response(Result result) {
            this(result, null);
        }

        public boolean is(Result result) {
            return this.result.equals((Object)result);
        }
    }

    public static enum Result {
        SUCCEEDED,
        FAILED,
        ABORTED;

    }
}

