/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.services.FlowService;
import io.kestra.core.services.NamespaceService;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.InternalKVStore;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVStoreException;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class KVStoreService {
    @Inject
    private StorageInterface storageInterface;
    @Inject
    private FlowService flowService;
    @Inject
    private NamespaceService namespaceService;

    public KVStore get(String tenant, String namespace, @Nullable String fromNamespace) {
        boolean checkIfNamespaceExists;
        boolean isNotSameNamespace;
        boolean bl = isNotSameNamespace = fromNamespace != null && !namespace.equals(fromNamespace);
        if (isNotSameNamespace && KVStoreService.isNotParentNamespace(namespace, fromNamespace)) {
            try {
                this.flowService.checkAllowedNamespace(tenant, namespace, tenant, fromNamespace);
            }
            catch (IllegalArgumentException e) {
                throw new KVStoreException(String.format("Cannot access the KV store. Access to '%s' namespace is not allowed from '%s'.", namespace, fromNamespace));
            }
        }
        boolean bl2 = checkIfNamespaceExists = fromNamespace == null || KVStoreService.isNotParentNamespace(namespace, fromNamespace);
        if (checkIfNamespaceExists && !this.namespaceService.isNamespaceExists(tenant, namespace)) {
            InternalKVStore kvStore = new InternalKVStore(tenant, namespace, this.storageInterface);
            try {
                if (kvStore.list().isEmpty()) {
                    throw new KVStoreException(String.format("Cannot access the KV store. The namespace '%s' does not exist.", namespace));
                }
            }
            catch (IOException e) {
                throw new KVStoreException(e);
            }
            return kvStore;
        }
        return new InternalKVStore(tenant, namespace, this.storageInterface);
    }

    private static boolean isNotParentNamespace(String parentNamespace, String childNamespace) {
        return !childNamespace.startsWith(parentNamespace);
    }
}

