/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.annotations.Retryable;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.storages.FileAttributes;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageObject;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public interface StorageInterface
extends AutoCloseable,
Plugin {
    default public void init() throws IOException {
    }

    @Override
    default public void close() {
    }

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public InputStream get(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public InputStream getInstanceResource(@Nullable String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public StorageObject getWithMetadata(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public List<URI> allByPrefix(String var1, @Nullable String var2, URI var3, boolean var4) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public List<FileAttributes> list(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public List<FileAttributes> listInstanceResource(@Nullable String var1, URI var2) throws IOException;

    default public boolean exists(String tenantId, @Nullable String namespace, URI uri) {
        boolean bl;
        block8: {
            InputStream ignored = this.get(tenantId, namespace, uri);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ieo) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    default public boolean existsInstanceResource(@Nullable String namespace, URI uri) {
        boolean bl;
        block8: {
            InputStream ignored = this.getInstanceResource(namespace, uri);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ieo) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public FileAttributes getAttributes(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public FileAttributes getInstanceAttributes(@Nullable String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class})
    default public URI put(String tenantId, @Nullable String namespace, URI uri, InputStream data) throws IOException {
        return this.put(tenantId, namespace, uri, new StorageObject(null, data));
    }

    @Retryable(includes={IOException.class})
    public URI put(String var1, @Nullable String var2, URI var3, StorageObject var4) throws IOException;

    @Retryable(includes={IOException.class})
    default public URI putInstanceResource(@Nullable String namespace, URI uri, InputStream data) throws IOException {
        return this.putInstanceResource(namespace, uri, new StorageObject(null, data));
    }

    @Retryable(includes={IOException.class})
    public URI putInstanceResource(@Nullable String var1, URI var2, StorageObject var3) throws IOException;

    @Retryable(includes={IOException.class})
    public boolean delete(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class})
    public boolean deleteInstanceResource(@Nullable String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class})
    public URI createDirectory(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class})
    public URI createInstanceDirectory(String var1, URI var2) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public URI move(String var1, @Nullable String var2, URI var3, URI var4) throws IOException;

    @Retryable(includes={IOException.class})
    public List<URI> deleteByPrefix(String var1, @Nullable String var2, URI var3) throws IOException;

    @Retryable(includes={IOException.class})
    default public URI from(Execution execution, String input, String fileName, File file) throws IOException {
        URI uri = StorageContext.forInput(execution, input, fileName).getContextStorageURI();
        return this.put(execution.getTenantId(), execution.getNamespace(), uri, new BufferedInputStream(new FileInputStream(file)));
    }

    default public void parentTraversalGuard(URI uri) {
        if (uri != null && (uri.toString().contains(".." + File.separator) || uri.toString().contains(File.separator + "..") || uri.toString().equals(".."))) {
            throw new IllegalArgumentException("File should be accessed with their full path and not using relative '..' path.");
        }
    }

    default public String getPath(URI uri) {
        if (uri == null) {
            uri = URI.create("/");
        }
        this.parentTraversalGuard(uri);
        String path = uri.getPath();
        path = path.replaceFirst("^/", "");
        return path;
    }

    default public String getPath(String tenantId, URI uri) {
        Object path = this.getPath(uri);
        path = tenantId + (String)(((String)path).startsWith("/") ? path : "/" + (String)path);
        return path;
    }
}

