/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages.kv;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class KVMetadata {
    private String description;
    private Instant expirationDate;

    public KVMetadata(String description, Duration ttl) {
        if (ttl != null && ttl.isNegative()) {
            throw new IllegalArgumentException("ttl cannot be negative");
        }
        this.description = description;
        if (ttl != null) {
            this.expirationDate = Instant.now().plus(ttl);
        }
    }

    public KVMetadata(String description, Instant expirationDate) {
        this.description = description;
        this.expirationDate = expirationDate;
    }

    public KVMetadata(Map<String, String> metadata) {
        if (metadata == null) {
            return;
        }
        this.description = metadata.get("description");
        this.expirationDate = Optional.ofNullable(metadata.get("expirationDate")).map(Instant::parse).orElse(null);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.description != null) {
            map.put("description", this.description);
        }
        if (this.expirationDate != null) {
            map.put("expirationDate", this.expirationDate.toString());
        }
        return map;
    }

    public String toString() {
        return "[description=" + this.description + ", expirationDate=" + String.valueOf(this.expirationDate) + "]";
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVMetadata)) {
            return false;
        }
        KVMetadata other = (KVMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Instant this$expirationDate = this.getExpirationDate();
        Instant other$expirationDate = other.getExpirationDate();
        return !(this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Instant $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        return result;
    }
}

