/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages.kv;

import io.kestra.core.exceptions.ResourceExpiredException;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public interface KVStore {
    public static final Pattern KEY_VALIDATOR_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9._-]*");

    public String namespace();

    default public URI storageUri(String key) {
        return this.storageUri(key, this.namespace());
    }

    default public URI storageUri(String key, String namespace) {
        Object filePath = key == null ? "" : "/" + key + ".ion";
        return URI.create("kestra://" + StorageContext.kvPrefix(namespace) + (String)filePath);
    }

    default public void put(String key, KVValueAndMetadata value) throws IOException {
        this.put(key, value, true);
    }

    public void put(String var1, KVValueAndMetadata var2, boolean var3) throws IOException;

    public Optional<KVValue> getValue(String var1) throws IOException, ResourceExpiredException;

    public boolean delete(String var1) throws IOException;

    public List<KVEntry> list() throws IOException;

    public List<KVEntry> listAll() throws IOException;

    public Optional<KVEntry> get(String var1) throws IOException;

    default public boolean exists(String key) throws IOException {
        return this.list().stream().anyMatch(kvEntry -> kvEntry.key().equals(key));
    }

    default public Optional<KVValueAndMetadata> findMetadataAndValue(String key) throws UncheckedIOException {
        try {
            return this.get(key).flatMap(entry -> {
                try {
                    return this.getValue(entry.key()).map(current -> new KVValueAndMetadata(new KVMetadata(entry.description(), entry.expirationDate()), current.value()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (ResourceExpiredException e) {
                    return Optional.empty();
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void validateKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (!KEY_VALIDATOR_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException("Key must start with an alphanumeric character (uppercase or lowercase) and can contain alphanumeric characters (uppercase or lowercase), dots (.), underscores (_), and hyphens (-) only.");
        }
    }
}

