/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.test.flow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.test.flow.AssertionResult;
import io.kestra.core.test.flow.AssertionRunError;
import io.kestra.core.validations.TestSuiteAssertionValidation;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@TestSuiteAssertionValidation
public class Assertion {
    @NotNull
    private Property<Object> value;
    private String taskId;
    private Property<String> errorMessage;
    private Property<String> description;
    private Property<String> endsWith;
    private Property<String> startsWith;
    private Property<String> contains;
    private Property<Object> equalTo;
    private Property<Object> notEqualTo;
    private Property<Double> greaterThan;
    private Property<Double> greaterThanOrEqualTo;
    private Property<Double> lessThan;
    private Property<Double> lessThanOrEqualTo;
    private Property<List<String>> in;
    private Property<List<String>> notIn;
    private Property<Boolean> isNull;
    private Property<Boolean> isNotNull;

    public boolean hasAtLeastOneAssertion() {
        return this.endsWith != null || this.startsWith != null || this.contains != null || this.equalTo != null || this.notEqualTo != null || this.greaterThan != null || this.greaterThanOrEqualTo != null || this.lessThan != null || this.lessThanOrEqualTo != null || this.in != null || this.notIn != null || this.isNull != null || this.isNotNull != null;
    }

    public AssertionRunResult run(RunContext runContext) {
        ArrayList<AssertionResult> results = new ArrayList<AssertionResult>();
        ArrayList<AssertionRunError> errors = new ArrayList<AssertionRunError>();
        try {
            List<String> notExpectedInList;
            List<String> expectedInList;
            Optional<Double> expectedLessThanOrEqualToValue;
            Optional<Double> expectedLessThanValue;
            Optional<Double> expectedGreaterThanOrEqualToValue;
            String actualValueQuery = this.getValue().toString();
            Object actualValue = runContext.render(this.getValue()).as(Object.class).orElse(null);
            Optional<String> errorMessage = runContext.render(this.getErrorMessage()).as(String.class);
            Optional<String> description = runContext.render(this.getDescription()).as(String.class);
            Optional<String> taskId = Optional.ofNullable(this.getTaskId());
            runContext.render(this.getIsNull()).as(Boolean.class).ifPresent(isNullExpected -> results.add(this.getIsNullResult(Operator.IS_NULL, (Boolean)isNullExpected, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getIsNotNull()).as(Boolean.class).ifPresent(isNotNullExpected -> results.add(this.getIsNullResult(Operator.IS_NOT_NULL, isNotNullExpected == false, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getEndsWith()).as(String.class).ifPresent(expectedValue -> results.add(this.endsWith((String)expectedValue, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getStartsWith()).as(String.class).ifPresent(expectedValue -> results.add(this.startsWith((String)expectedValue, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getEqualTo()).as(Object.class).ifPresent(expectedValue -> results.add(this.equalTo(expectedValue, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getContains()).as(String.class).ifPresent(expectedValue -> results.add(this.contains((String)expectedValue, actualValueQuery, actualValue, taskId, description, errorMessage)));
            runContext.render(this.getNotEqualTo()).as(Object.class).ifPresent(expectedValue -> results.add(this.notEqualTo(expectedValue, actualValueQuery, actualValue, taskId, description, errorMessage)));
            Optional<Double> expectedGreaterThanValue = runContext.render(this.getGreaterThan()).as(Double.class);
            if (expectedGreaterThanValue.isPresent()) {
                results.add(this.greaterThan(expectedGreaterThanValue.get(), actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if ((expectedGreaterThanOrEqualToValue = runContext.render(this.getGreaterThanOrEqualTo()).as(Double.class)).isPresent()) {
                results.add(this.greaterThanOrEqualTo(expectedGreaterThanOrEqualToValue.get(), actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if ((expectedLessThanValue = runContext.render(this.getLessThan()).as(Double.class)).isPresent()) {
                results.add(this.lessThan(expectedLessThanValue.get(), actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if ((expectedLessThanOrEqualToValue = runContext.render(this.getLessThanOrEqualTo()).as(Double.class)).isPresent()) {
                results.add(this.lessThanOrEqualTo(expectedLessThanOrEqualToValue.get(), actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if (!(expectedInList = runContext.render(this.getIn()).asList(String.class)).isEmpty()) {
                results.add(this.in(expectedInList, actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if (!(notExpectedInList = runContext.render(this.getNotIn()).asList(String.class)).isEmpty()) {
                results.add(this.notIn(notExpectedInList, actualValueQuery, actualValue, taskId, description, errorMessage));
            }
            if (results.isEmpty()) {
                errors.add(new AssertionRunError("no assertions found", null));
            }
        }
        catch (IllegalVariableEvaluationException e) {
            errors.add(new AssertionRunError("Could not evaluate assertion: `%s`".formatted(this.getDisplayableAssertion()), "error was: %s".formatted(e.getMessage())));
        }
        return new AssertionRunResult(results, errors);
    }

    private String getDisplayableAssertion() {
        try {
            return JacksonMapper.ofJson().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private AssertionResult getIsNullResult(Operator operator, Boolean isNullExpected, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> userErrorMessage) {
        boolean isNull = actualValue == null;
        boolean isSuccess = isNullExpected.equals(isNull);
        String errorMessage = null;
        if (!isSuccess) {
            errorMessage = userErrorMessage.orElseGet(() -> {
                if (isNullExpected.booleanValue()) {
                    return "expected '%s' to be null but was '%s'".formatted(actualValueQuery, actualValue);
                }
                return "expected '%s' to be not null but was 'null'".formatted(actualValueQuery);
            });
        }
        return new AssertionResult(operator.toString(), operator.toString(), actualValue, isSuccess, taskId.orElse(null), description.orElse(null), errorMessage);
    }

    private AssertionResult equalTo(Object expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = expectedValue.equals(actualValue);
        return new AssertionResult(Operator.EQUAL_TO.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to equal '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult notEqualTo(Object expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = !expectedValue.equals(actualValue);
        return new AssertionResult(Operator.NOT_EQUAL_TO.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to not equal '%s'".formatted(actualValueQuery, expectedValue.toString())));
    }

    private AssertionResult endsWith(String expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = ((String)actualValue).endsWith(expectedValue);
        return new AssertionResult(Operator.ENDS_WITH.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to end with '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult startsWith(String expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = ((String)actualValue).startsWith(expectedValue);
        return new AssertionResult(Operator.STARTS_WITH.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to start with '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult contains(String expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = ((String)actualValue).contains(expectedValue);
        return new AssertionResult(Operator.CONTAINS.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to contain '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult greaterThan(Double expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) throws IllegalVariableEvaluationException {
        boolean isSuccess = this.tryToParseDouble(actualValue) > expectedValue;
        return new AssertionResult(Operator.GREATER_THAN.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to be greater than '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult greaterThanOrEqualTo(Double expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) throws IllegalVariableEvaluationException {
        boolean isSuccess = this.tryToParseDouble(actualValue) >= expectedValue;
        return new AssertionResult(Operator.GREATER_THAN_OR_EQUAL_TO.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to be greater than or equal to '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult lessThan(Double expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) throws IllegalVariableEvaluationException {
        boolean isSuccess = this.tryToParseDouble(actualValue) < expectedValue;
        return new AssertionResult(Operator.LESS_THAN.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to be less than '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private AssertionResult lessThanOrEqualTo(Double expectedValue, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) throws IllegalVariableEvaluationException {
        boolean isSuccess = this.tryToParseDouble(actualValue) <= expectedValue;
        return new AssertionResult(Operator.LESS_THAN_OR_EQUAL_TO.toString(), expectedValue, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to be less than or equal to '%s' but was '%s'".formatted(actualValueQuery, expectedValue, actualValue)));
    }

    private Double tryToParseDouble(Object x) throws IllegalVariableEvaluationException {
        if (x instanceof Double) {
            return (Double)x;
        }
        try {
            return Double.parseDouble(x.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalVariableEvaluationException("Could not parse value as a Double");
        }
    }

    private AssertionResult in(List<String> expectedInList, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = expectedInList.stream().anyMatch(actualValue::equals);
        return new AssertionResult(Operator.IN.toString(), expectedInList, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to contain '%s' but was '%s'".formatted(actualValueQuery, expectedInList, actualValue)));
    }

    private AssertionResult notIn(List<String> notExpectedInList, String actualValueQuery, Object actualValue, Optional<String> taskId, Optional<String> description, Optional<String> errorMessage) {
        boolean isSuccess = notExpectedInList.stream().noneMatch(actualValue::equals);
        return new AssertionResult(Operator.NOT_IN.toString(), notExpectedInList, actualValue, isSuccess, taskId.orElse(null), description.orElse(null), isSuccess ? null : errorMessage.orElse("expected '%s' to not contain '%s' but was '%s'".formatted(actualValueQuery, notExpectedInList, actualValue)));
    }

    @Generated
    public static AssertionBuilder builder() {
        return new AssertionBuilder();
    }

    @Generated
    public Property<Object> getValue() {
        return this.value;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public Property<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Property<String> getDescription() {
        return this.description;
    }

    @Generated
    public Property<String> getEndsWith() {
        return this.endsWith;
    }

    @Generated
    public Property<String> getStartsWith() {
        return this.startsWith;
    }

    @Generated
    public Property<String> getContains() {
        return this.contains;
    }

    @Generated
    public Property<Object> getEqualTo() {
        return this.equalTo;
    }

    @Generated
    public Property<Object> getNotEqualTo() {
        return this.notEqualTo;
    }

    @Generated
    public Property<Double> getGreaterThan() {
        return this.greaterThan;
    }

    @Generated
    public Property<Double> getGreaterThanOrEqualTo() {
        return this.greaterThanOrEqualTo;
    }

    @Generated
    public Property<Double> getLessThan() {
        return this.lessThan;
    }

    @Generated
    public Property<Double> getLessThanOrEqualTo() {
        return this.lessThanOrEqualTo;
    }

    @Generated
    public Property<List<String>> getIn() {
        return this.in;
    }

    @Generated
    public Property<List<String>> getNotIn() {
        return this.notIn;
    }

    @Generated
    public Property<Boolean> getIsNull() {
        return this.isNull;
    }

    @Generated
    public Property<Boolean> getIsNotNull() {
        return this.isNotNull;
    }

    @Generated
    public Assertion() {
    }

    @ConstructorProperties(value={"value", "taskId", "errorMessage", "description", "endsWith", "startsWith", "contains", "equalTo", "notEqualTo", "greaterThan", "greaterThanOrEqualTo", "lessThan", "lessThanOrEqualTo", "in", "notIn", "isNull", "isNotNull"})
    @Generated
    public Assertion(Property<Object> value, String taskId, Property<String> errorMessage, Property<String> description, Property<String> endsWith, Property<String> startsWith, Property<String> contains, Property<Object> equalTo, Property<Object> notEqualTo, Property<Double> greaterThan, Property<Double> greaterThanOrEqualTo, Property<Double> lessThan, Property<Double> lessThanOrEqualTo, Property<List<String>> in, Property<List<String>> notIn, Property<Boolean> isNull, Property<Boolean> isNotNull) {
        this.value = value;
        this.taskId = taskId;
        this.errorMessage = errorMessage;
        this.description = description;
        this.endsWith = endsWith;
        this.startsWith = startsWith;
        this.contains = contains;
        this.equalTo = equalTo;
        this.notEqualTo = notEqualTo;
        this.greaterThan = greaterThan;
        this.greaterThanOrEqualTo = greaterThanOrEqualTo;
        this.lessThan = lessThan;
        this.lessThanOrEqualTo = lessThanOrEqualTo;
        this.in = in;
        this.notIn = notIn;
        this.isNull = isNull;
        this.isNotNull = isNotNull;
    }

    public record AssertionRunResult(List<AssertionResult> results, List<AssertionRunError> errors) {
    }

    public static enum Operator {
        ENDS_WITH("endsWith"),
        STARTS_WITH("startsWith"),
        CONTAINS("contains"),
        EQUAL_TO("equalTo"),
        NOT_EQUAL_TO("notEqualTo"),
        GREATER_THAN("greaterThan"),
        GREATER_THAN_OR_EQUAL_TO("greaterThanOrEqualTo"),
        LESS_THAN("lessThan"),
        LESS_THAN_OR_EQUAL_TO("lessThanOrEqualTo"),
        IN("in"),
        NOT_IN("notIn"),
        IS_NULL("isNull"),
        IS_NOT_NULL("isNotNull");

        public final String key;

        private Operator(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    @Generated
    public static class AssertionBuilder {
        @Generated
        private Property<Object> value;
        @Generated
        private String taskId;
        @Generated
        private Property<String> errorMessage;
        @Generated
        private Property<String> description;
        @Generated
        private Property<String> endsWith;
        @Generated
        private Property<String> startsWith;
        @Generated
        private Property<String> contains;
        @Generated
        private Property<Object> equalTo;
        @Generated
        private Property<Object> notEqualTo;
        @Generated
        private Property<Double> greaterThan;
        @Generated
        private Property<Double> greaterThanOrEqualTo;
        @Generated
        private Property<Double> lessThan;
        @Generated
        private Property<Double> lessThanOrEqualTo;
        @Generated
        private Property<List<String>> in;
        @Generated
        private Property<List<String>> notIn;
        @Generated
        private Property<Boolean> isNull;
        @Generated
        private Property<Boolean> isNotNull;

        @Generated
        AssertionBuilder() {
        }

        @Generated
        public AssertionBuilder value(Property<Object> value) {
            this.value = value;
            return this;
        }

        @Generated
        public AssertionBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public AssertionBuilder errorMessage(Property<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Generated
        public AssertionBuilder description(Property<String> description) {
            this.description = description;
            return this;
        }

        @Generated
        public AssertionBuilder endsWith(Property<String> endsWith) {
            this.endsWith = endsWith;
            return this;
        }

        @Generated
        public AssertionBuilder startsWith(Property<String> startsWith) {
            this.startsWith = startsWith;
            return this;
        }

        @Generated
        public AssertionBuilder contains(Property<String> contains) {
            this.contains = contains;
            return this;
        }

        @Generated
        public AssertionBuilder equalTo(Property<Object> equalTo) {
            this.equalTo = equalTo;
            return this;
        }

        @Generated
        public AssertionBuilder notEqualTo(Property<Object> notEqualTo) {
            this.notEqualTo = notEqualTo;
            return this;
        }

        @Generated
        public AssertionBuilder greaterThan(Property<Double> greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        @Generated
        public AssertionBuilder greaterThanOrEqualTo(Property<Double> greaterThanOrEqualTo) {
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            return this;
        }

        @Generated
        public AssertionBuilder lessThan(Property<Double> lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        @Generated
        public AssertionBuilder lessThanOrEqualTo(Property<Double> lessThanOrEqualTo) {
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            return this;
        }

        @Generated
        public AssertionBuilder in(Property<List<String>> in) {
            this.in = in;
            return this;
        }

        @Generated
        public AssertionBuilder notIn(Property<List<String>> notIn) {
            this.notIn = notIn;
            return this;
        }

        @Generated
        public AssertionBuilder isNull(Property<Boolean> isNull) {
            this.isNull = isNull;
            return this;
        }

        @Generated
        public AssertionBuilder isNotNull(Property<Boolean> isNotNull) {
            this.isNotNull = isNotNull;
            return this;
        }

        @Generated
        public Assertion build() {
            return new Assertion(this.value, this.taskId, this.errorMessage, this.description, this.endsWith, this.startsWith, this.contains, this.equalTo, this.notEqualTo, this.greaterThan, this.greaterThanOrEqualTo, this.lessThan, this.lessThanOrEqualTo, this.in, this.notIn, this.isNull, this.isNotNull);
        }

        @Generated
        public String toString() {
            return "Assertion.AssertionBuilder(value=" + String.valueOf(this.value) + ", taskId=" + this.taskId + ", errorMessage=" + String.valueOf(this.errorMessage) + ", description=" + String.valueOf(this.description) + ", endsWith=" + String.valueOf(this.endsWith) + ", startsWith=" + String.valueOf(this.startsWith) + ", contains=" + String.valueOf(this.contains) + ", equalTo=" + String.valueOf(this.equalTo) + ", notEqualTo=" + String.valueOf(this.notEqualTo) + ", greaterThan=" + String.valueOf(this.greaterThan) + ", greaterThanOrEqualTo=" + String.valueOf(this.greaterThanOrEqualTo) + ", lessThan=" + String.valueOf(this.lessThan) + ", lessThanOrEqualTo=" + String.valueOf(this.lessThanOrEqualTo) + ", in=" + String.valueOf(this.in) + ", notIn=" + String.valueOf(this.notIn) + ", isNull=" + String.valueOf(this.isNull) + ", isNotNull=" + String.valueOf(this.isNotNull) + ")";
        }
    }
}

