/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.trace;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.RunContext;
import io.kestra.core.trace.TraceLevel;
import io.kestra.core.trace.TraceUtils;
import io.kestra.core.trace.Tracer;
import io.kestra.core.trace.propagation.ExecutionTextMapGetter;
import io.kestra.core.trace.propagation.RunContextTextMapGetter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;

class DefaultTracer
implements Tracer {
    private final OpenTelemetry openTelemetry;
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final String spanNamePrefix;
    private final TraceLevel level;
    private final Attributes baseAttributes;

    DefaultTracer(OpenTelemetry openTelemetry, io.opentelemetry.api.trace.Tracer tracer, String spanNamePrefix, TraceLevel level, Attributes baseAttributes) {
        this.openTelemetry = openTelemetry;
        this.tracer = tracer;
        this.spanNamePrefix = spanNamePrefix;
        this.level = level;
        this.baseAttributes = baseAttributes;
    }

    @Override
    public <V> V inCurrentContext(RunContext runContext, String spanName, Tracer.Callable<V> callable) {
        return this.inCurrentContext(runContext, spanName, null, callable);
    }

    @Override
    public <V> V inCurrentContext(RunContext runContext, String spanName, Attributes additionalAttributes, Tracer.Callable<V> callable) {
        TextMapPropagator propagator = this.openTelemetry.getPropagators().getTextMapPropagator();
        Context extractedContext = propagator.extract(Context.current(), (Object)runContext, (TextMapGetter)RunContextTextMapGetter.INSTANCE);
        AttributesBuilder attributesBuilder = Attributes.builder().putAll(this.baseAttributes).putAll(TraceUtils.attributesFrom(runContext));
        if (additionalAttributes != null) {
            attributesBuilder.putAll(additionalAttributes);
        }
        return this.inCurrentContext(extractedContext, spanName, attributesBuilder.build(), callable);
    }

    @Override
    public <V> V inCurrentContext(Execution execution, String spanName, Tracer.Callable<V> callable) {
        return this.inCurrentContext(execution, spanName, null, callable);
    }

    @Override
    public <V> V inCurrentContext(Execution execution, String spanName, Attributes additionalAttributes, Tracer.Callable<V> callable) {
        TextMapPropagator propagator = this.openTelemetry.getPropagators().getTextMapPropagator();
        Context extractedContext = propagator.extract(Context.current(), (Object)execution, (TextMapGetter)ExecutionTextMapGetter.INSTANCE);
        AttributesBuilder attributesBuilder = Attributes.builder().putAll(this.baseAttributes).putAll(TraceUtils.attributesFrom(execution));
        if (additionalAttributes != null) {
            attributesBuilder.putAll(additionalAttributes);
        }
        return this.inCurrentContext(extractedContext, spanName, attributesBuilder.build(), callable);
    }

    @Override
    public <V> V inNewContext(Execution execution, String spanName, Tracer.Callable<V> callable) {
        return this.inNewContext(execution, spanName, null, callable);
    }

    @Override
    public <V> V inNewContext(Execution execution, String spanName, Attributes additionalAttributes, Tracer.Callable<V> callable) {
        AttributesBuilder attributesBuilder = Attributes.builder().putAll(this.baseAttributes).putAll(TraceUtils.attributesFrom(execution));
        if (additionalAttributes != null) {
            attributesBuilder.putAll(additionalAttributes);
        }
        return this.inNewContext(spanName, attributesBuilder.build(), callable);
    }

    /*
     * Loose catch block
     */
    private <V> V inCurrentContext(Context context, String spanName, Attributes attributes, Tracer.Callable<V> callable) {
        try (Scope ignored = context.makeCurrent();){
            V v;
            Span span = this.tracer.spanBuilder(this.spanNamePrefix + " - " + spanName).setAllAttributes(attributes).startSpan();
            try {
                v = callable.call();
            }
            catch (Exception e) {
                span.setStatus(StatusCode.ERROR, e.getMessage());
                throw e;
            }
            finally {
                span.end();
            }
            return v;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private <V> V inNewContext(String spanName, Attributes attributes, Tracer.Callable<V> callable) {
        Span span = this.tracer.spanBuilder(this.spanNamePrefix + " - " + spanName).setAllAttributes(attributes).startSpan();
        try {
            V v;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    v = callable.call();
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.setStatus(StatusCode.ERROR, e.getMessage());
                        throw e;
                    }
                }
                ignored.close();
            }
            return v;
        }
        finally {
            span.end();
        }
    }
}

