/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.trace;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.RunContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Map;

public final class TraceUtils {
    public static final AttributeKey<String> ATTR_UID = AttributeKey.stringKey((String)"kestra.uid");
    private static final AttributeKey<String> ATTR_TENANT_ID = AttributeKey.stringKey((String)"kestra.tenantId");
    private static final AttributeKey<String> ATTR_NAMESPACE = AttributeKey.stringKey((String)"kestra.namespace");
    private static final AttributeKey<String> ATTR_FLOW_ID = AttributeKey.stringKey((String)"kestra.flowId");
    private static final AttributeKey<String> ATTR_EXECUTION_ID = AttributeKey.stringKey((String)"kestra.executionId");
    public static final AttributeKey<String> ATTR_SOURCE = AttributeKey.stringKey((String)"kestra.source");

    private TraceUtils() {
    }

    public static Attributes attributesFrom(Execution execution) {
        AttributesBuilder builder = Attributes.builder().put(ATTR_NAMESPACE, (Object)execution.getNamespace()).put(ATTR_FLOW_ID, (Object)execution.getFlowId()).put(ATTR_EXECUTION_ID, (Object)execution.getId());
        if (execution.getTenantId() != null) {
            builder.put(ATTR_TENANT_ID, (Object)execution.getTenantId());
        }
        return builder.build();
    }

    public static Attributes attributesFrom(RunContext runContext) {
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        Map execution = (Map)runContext.getVariables().get("execution");
        String executionId = execution != null ? (String)execution.get("id") : null;
        AttributesBuilder builder = Attributes.builder().put(ATTR_NAMESPACE, (Object)flowInfo.namespace()).put(ATTR_FLOW_ID, (Object)flowInfo.id());
        if (executionId != null) {
            builder.put(ATTR_EXECUTION_ID, (Object)executionId);
        }
        if (flowInfo.tenantId() != null) {
            builder.put(ATTR_TENANT_ID, (Object)flowInfo.tenantId());
        }
        return builder.build();
    }

    public static Attributes attributesFrom(Class<?> clazz) {
        return Attributes.builder().put(ATTR_SOURCE, (Object)clazz.getName()).build();
    }
}

