/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.trace;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.opentelemetry.api.common.Attributes;

public interface Tracer {
    public <V> V inCurrentContext(RunContext var1, String var2, Callable<V> var3);

    public <V> V inCurrentContext(RunContext var1, String var2, Attributes var3, Callable<V> var4);

    public <V> V inCurrentContext(Execution var1, String var2, Callable<V> var3);

    public <V> V inCurrentContext(Execution var1, String var2, Attributes var3, Callable<V> var4);

    public <V> V inNewContext(Execution var1, String var2, Callable<V> var3);

    public <V> V inNewContext(Execution var1, String var2, Attributes var3, Callable<V> var4);

    public static <R, E extends Exception> Callable<R> throwCallable(Rethrow.CallableChecked<R, E> runnable) throws E {
        return () -> {
            try {
                return runnable.call();
            }
            catch (Exception exception) {
                return Tracer.throwException(exception);
            }
        };
    }

    private static <E extends Exception, R> R throwException(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface Callable<V> {
        public V call();
    }

    @FunctionalInterface
    public static interface CallableChecked<R, E extends Exception> {
        public R call() throws E;
    }
}

