/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.util.ArrayList;
import java.util.List;

public class ListUtils {
    public static <T> List<T> emptyOnNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> List<T> concat(List<T> list1, List<T> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        ArrayList<T> newList = new ArrayList<T>(list1.size() + list2.size());
        newList.addAll(list1);
        newList.addAll(list2);
        return newList;
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> list1, List<T> list2, List<T> ... lists) {
        ArrayList<T> newList = new ArrayList<T>();
        if (!ListUtils.isEmpty(list1)) {
            newList.addAll(list1);
        }
        if (!ListUtils.isEmpty(list2)) {
            newList.addAll(list2);
        }
        if (lists != null) {
            for (List<T> list : lists) {
                if (ListUtils.isEmpty(list)) continue;
                newList.addAll(list);
            }
        }
        return newList;
    }

    public static List<?> convertToList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list;
        }
        throw new IllegalArgumentException("%s in not an instance of List".formatted(object.getClass()));
    }

    public static List<String> convertToListString(Object object) {
        List list;
        if (object instanceof List && ((list = (List)object).isEmpty() || list.getFirst() instanceof String)) {
            return list;
        }
        throw new IllegalArgumentException("%s in not an instance of List of String".formatted(object));
    }
}

