/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Version
implements Comparable<Version> {
    public static final Version ZERO = new Version(0, 0, 0, null);
    private final int majorVersion;
    private final int minorVersion;
    private final int incrementalVersion;
    private final Qualifier qualifier;
    private final String originalVersion;

    public static boolean isEqual(String v1, String v2) {
        return Version.isEqual(Version.of(v1), v2);
    }

    public static boolean isEqual(Version v1, String v2) {
        return v1.equals(Version.of(v2));
    }

    public static Version of(String version) {
        int qualifier;
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        String[] versions = (qualifier = version.indexOf("-")) > 0 ? version.substring(0, qualifier).split("\\.") : version.split("\\.");
        try {
            int majorVersion = Integer.parseInt(versions[0]);
            int minorVersion = versions.length > 1 ? Integer.parseInt(versions[1]) : 0;
            int incrementalVersion = versions.length > 2 ? Integer.parseInt(versions[2]) : 0;
            return new Version(majorVersion, minorVersion, incrementalVersion, qualifier > 0 ? version.substring(qualifier + 1) : null, version);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version, cannot parse '" + version + "'");
        }
    }

    public static Version getStable(Version from, Collection<Version> versions) {
        List<Version> compatibleVersions = versions.stream().filter(v -> v.majorVersion() == from.majorVersion() && v.minorVersion() == from.minorVersion()).toList();
        if (compatibleVersions.isEmpty()) {
            return null;
        }
        return Version.getLatest(compatibleVersions);
    }

    public static Version getLatest(Version ... versions) {
        return Version.getLatest(Stream.of(versions).toList());
    }

    public static Version getLatest(Collection<Version> versions) {
        return versions.stream().filter(Objects::nonNull).min(Comparator.naturalOrder()).orElseThrow(() -> new IllegalArgumentException("empty list"));
    }

    public static Version getOldest(Version ... versions) {
        return Version.getOldest(Stream.of(versions).toList());
    }

    public static Version getOldest(Collection<Version> versions) {
        return versions.stream().filter(Objects::nonNull).max(Comparator.naturalOrder()).orElseThrow(() -> new IllegalArgumentException("empty list"));
    }

    public Version(int majorVersion, int minorVersion, int incrementalVersion, String qualifier) {
        this(majorVersion, minorVersion, incrementalVersion, qualifier, null);
    }

    private Version(int majorVersion, int minorVersion, int incrementalVersion, String qualifier, String originalVersion) {
        this.majorVersion = Version.requirePositive(majorVersion, "major");
        this.minorVersion = Version.requirePositive(minorVersion, "minor");
        this.incrementalVersion = Version.requirePositive(incrementalVersion, "incremental");
        this.qualifier = qualifier != null ? new Qualifier(qualifier) : null;
        this.originalVersion = originalVersion;
    }

    private static int requirePositive(int version, String message) {
        if (version < 0) {
            throw new IllegalArgumentException(String.format("The '%s' version must super or equal to 0", message));
        }
        return version;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int incrementalVersion() {
        return this.incrementalVersion;
    }

    public Qualifier qualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.incrementalVersion == version.incrementalVersion && Objects.equals(this.qualifier, version.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.incrementalVersion, this.qualifier);
    }

    public String toString() {
        if (this.originalVersion != null) {
            return this.originalVersion;
        }
        String version = this.majorVersion + "." + this.minorVersion + "." + this.incrementalVersion;
        return this.qualifier != null ? version + "-" + String.valueOf(this.qualifier) : version;
    }

    @Override
    public int compareTo(Version that) {
        int compareMajor = Integer.compare(that.majorVersion, this.majorVersion);
        if (compareMajor != 0) {
            return compareMajor;
        }
        int compareMinor = Integer.compare(that.minorVersion, this.minorVersion);
        if (compareMinor != 0) {
            return compareMinor;
        }
        int compareIncremental = Integer.compare(that.incrementalVersion, this.incrementalVersion);
        if (compareIncremental != 0) {
            return compareIncremental;
        }
        if (that.qualifier == null && this.qualifier == null) {
            return 0;
        }
        if (that.qualifier == null) {
            return 1;
        }
        if (this.qualifier == null) {
            return -1;
        }
        return this.qualifier.compareTo(that.qualifier);
    }

    public boolean isBefore(Version version) {
        return this.compareTo(version) > 0;
    }

    private static int getQualifierNumber(String qualifier) {
        char[] chars;
        StringBuilder label = new StringBuilder();
        for (char c : chars = qualifier.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            label.append(c);
        }
        return label.isEmpty() ? 0 : Integer.parseInt(label.toString());
    }

    private static String getUniformQualifier(String qualifier) {
        char[] chars;
        StringBuilder label = new StringBuilder();
        for (char c : chars = qualifier.toCharArray()) {
            if (!Character.isLetter(c)) break;
            label.append(c);
        }
        return label.toString().toUpperCase();
    }

    public static final class Qualifier
    implements Comparable<Qualifier> {
        private static final List<String> DEFAULT_QUALIFIER_NAME = new ArrayList<String>();
        private final String qualifier;
        private final String label;
        private final int priority;
        private final int number;

        Qualifier(String qualifier) {
            Objects.requireNonNull(qualifier, "qualifier cannot be null");
            this.qualifier = qualifier;
            this.label = Version.getUniformQualifier(qualifier);
            this.priority = DEFAULT_QUALIFIER_NAME.indexOf(this.label);
            this.number = this.label.length() < qualifier.length() ? Version.getQualifierNumber(qualifier) : 0;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Qualifier)) {
                return false;
            }
            return this.qualifier.equalsIgnoreCase(((Qualifier)that).qualifier);
        }

        public int hashCode() {
            return Objects.hash(this.qualifier);
        }

        @Override
        public int compareTo(Qualifier that) {
            int compare = Integer.compare(that.priority, this.priority);
            return compare != 0 ? compare : Integer.compare(that.number, this.number);
        }

        public String toString() {
            return this.qualifier;
        }

        static {
            DEFAULT_QUALIFIER_NAME.add("ALPHA");
            DEFAULT_QUALIFIER_NAME.add("BETA");
            DEFAULT_QUALIFIER_NAME.add("SNAPSHOT");
            DEFAULT_QUALIFIER_NAME.add("RC");
            DEFAULT_QUALIFIER_NAME.add("RELEASE");
        }
    }
}

