/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.dashboards.AggregationType;
import io.kestra.core.models.dashboards.ChartOption;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.OrderBy;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.validations.DataChartValidation;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
@Introspected
public class DataChartValidator
implements ConstraintValidator<DataChartValidation, DataChart<?, ?>> {
    @Value(value="${kestra.repository.type}")
    private String repositoryType;

    public boolean isValid(@Nullable DataChart<?, ?> dataChart, @NonNull AnnotationValue<DataChartValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        Set usedFields;
        List<OrderBy> orderBy;
        if (dataChart == null) {
            return true;
        }
        ArrayList<Object> violations = new ArrayList<Object>();
        Set<String> dataColumns = MapUtils.emptyOnNull(((DataFilter)dataChart.getData()).getColumns()).keySet();
        if (dataChart.getChartOptions() != null) {
            List<String> neededColumns = ((ChartOption)dataChart.getChartOptions()).neededColumns();
            neededColumns.forEach(column -> {
                if (!dataColumns.contains(column)) {
                    violations.add("Column '" + column + "' is requested by the chart but not present in `data.columns` keys.");
                }
            });
        }
        if ((orderBy = ((DataFilter)dataChart.getData()).getOrderBy()) != null) {
            orderBy.stream().map(OrderBy::getColumn).forEach(column -> {
                if (!dataColumns.contains(column)) {
                    violations.add("Column '" + column + "' is used in `orderBy` but not present in `data.columns` keys.");
                }
            });
        }
        ((DataFilter)dataChart.getData()).getColumns().forEach((key, value) -> {
            if (value.getField() == null && value.getAgg() != AggregationType.COUNT) {
                violations.add("Column '" + key + "' doesn't have a field to select from.");
            }
        });
        Integer minNumberOfAggregations = dataChart.minNumberOfAggregations();
        Integer maxNumberOfAggregations = dataChart.maxNumberOfAggregations();
        List<ColumnDescriptor> aggregationsColumns = ((DataFilter)dataChart.getData()).getColumns().values().stream().filter(column -> column.getAgg() != null).toList();
        if (minNumberOfAggregations != null && aggregationsColumns.size() < minNumberOfAggregations) {
            violations.add("At least " + minNumberOfAggregations + " aggregation is needed for " + dataChart.getClass().getName() + ".");
        }
        if (maxNumberOfAggregations != null && aggregationsColumns.size() > maxNumberOfAggregations) {
            violations.add("At most " + minNumberOfAggregations + " aggregation can be provided for " + dataChart.getClass().getName() + ".");
        }
        if (!aggregationsColumns.isEmpty()) {
            List<Enum> aggregationForbiddenFieldsUsed = ((DataFilter)dataChart.getData()).getColumns().values().stream().map(ColumnDescriptor::getField).filter(Objects::nonNull).filter(((DataFilter)dataChart.getData()).aggregationForbiddenFields()::contains).toList();
            if (!aggregationForbiddenFieldsUsed.isEmpty()) {
                violations.add(String.valueOf(aggregationForbiddenFieldsUsed) + " can't be used as or with aggregations.");
            }
        }
        if ((usedFields = ((DataFilter)dataChart.getData()).getColumns().values().stream().map(c -> String.valueOf((Object)c.getAgg()) + "-" + String.valueOf(c.getField()) + "-" + c.getLabelKey()).collect(Collectors.toSet())).size() != ((DataFilter)dataChart.getData()).getColumns().size()) {
            violations.add("Fields can only appear once in `data.columns`.");
        }
        if (((DataFilter)dataChart.getData()).getColumns().entrySet().stream().anyMatch(entry -> ((ColumnDescriptor)entry.getValue()).getField() != null && ((Enum)((ColumnDescriptor)entry.getValue()).getField()).equals((Object)IExecutions.Fields.LABELS)) && !this.repositoryType.equals("elasticsearch")) {
            violations.add("LABELS column is only supported with an ElasticSearch database.");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid data chart: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

