/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.validations.PluginDefaultValidation;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Singleton
@Introspected
public class PluginDefaultValidator
implements ConstraintValidator<PluginDefaultValidation, PluginDefault> {
    @Inject
    private PluginDefaultService pluginDefaultService;

    public boolean isValid(@Nullable PluginDefault value, @NonNull AnnotationValue<PluginDefaultValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (value.getValues() == null) {
            violations.add("No 'values' provided");
            PluginDefaultValidator.addConstraintViolation(context, violations);
            return false;
        }
        if (value.getType() == null) {
            violations.add("No 'type' provided");
        }
        for (Map.Entry<String, Object> entry : value.getValues().entrySet()) {
            if (entry.getValue() != null) continue;
            violations.add("No value provided for key '" + entry.getKey() + "'");
        }
        List<String> strings = this.pluginDefaultService.validateDefault(value);
        if (!strings.isEmpty()) {
            violations.addAll(strings);
        }
        if (!violations.isEmpty()) {
            PluginDefaultValidator.addConstraintViolation(context, violations);
            return false;
        }
        return true;
    }

    private static void addConstraintViolation(ConstraintValidatorContext context, List<String> violations) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("Invalid Plugin Default: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
    }
}

