/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition to execute tasks on a specific day of the week relative to the current month (first, last, ...)")
@Plugin(examples={@Example(title="Trigger condition to execute the flow only on the first Monday of the month.", full=true, code={"id: schedule_condition_dayweekinmonth\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute only on the first Monday of the month at 11:00 am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.DayWeekInMonth\n        dayOfWeek: \"MONDAY\"\n        dayInMonth: FIRST\n"})}, aliases={"io.kestra.core.models.conditions.types.DayWeekInMonthCondition", "io.kestra.plugin.core.condition.DayWeekInMonthCondition"})
public class DayWeekInMonth
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test.", description="Can be any variable or any valid ISO 8601 datetime. By default, it will use the trigger date.")
    @PluginProperty(dynamic=true)
    private final String date;
    @NotNull
    @Schema(title="The day of week.")
    private Property<DayOfWeek> dayOfWeek;
    @NotNull
    @Schema(title="Are you looking for the first or the last day in the month?")
    private Property<DayInMonth> dayInMonth;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        LocalDate computed;
        Map<String, Object> vars = conditionContext.getVariables();
        RunContext runContext = conditionContext.getRunContext();
        String render = runContext.render(this.date, vars);
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        DayOfWeek renderedDayOfWeek = runContext.render(this.dayOfWeek).as(DayOfWeek.class, vars).orElseThrow();
        DayInMonth renderedDayInMonth = runContext.render(this.dayInMonth).as(DayInMonth.class, vars).orElseThrow();
        if (renderedDayInMonth.equals((Object)DayInMonth.FIRST)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(renderedDayOfWeek));
        } else if (renderedDayInMonth.equals((Object)DayInMonth.LAST)) {
            computed = currentDate.with(TemporalAdjusters.lastInMonth(renderedDayOfWeek));
        } else if (renderedDayInMonth.equals((Object)DayInMonth.SECOND)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek));
        } else if (renderedDayInMonth.equals((Object)DayInMonth.THIRD)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek));
        } else if (renderedDayInMonth.equals((Object)DayInMonth.FOURTH)) {
            computed = currentDate.with(TemporalAdjusters.firstInMonth(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek)).with(TemporalAdjusters.next(renderedDayOfWeek));
        } else {
            throw new IllegalArgumentException("Invalid dayInMonth");
        }
        return computed.isEqual(currentDate);
    }

    @Generated
    private static String $default$date() {
        return "{{ trigger.date }}";
    }

    @Generated
    protected DayWeekInMonth(DayWeekInMonthBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : DayWeekInMonth.$default$date();
        this.dayOfWeek = b.dayOfWeek;
        this.dayInMonth = b.dayInMonth;
    }

    @Generated
    public static DayWeekInMonthBuilder<?, ?> builder() {
        return new DayWeekInMonthBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DayWeekInMonth(super=" + super.toString() + ", date=" + this.getDate() + ", dayOfWeek=" + String.valueOf(this.getDayOfWeek()) + ", dayInMonth=" + String.valueOf(this.getDayInMonth()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayWeekInMonth)) {
            return false;
        }
        DayWeekInMonth other = (DayWeekInMonth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        Property<DayOfWeek> this$dayOfWeek = this.getDayOfWeek();
        Property<DayOfWeek> other$dayOfWeek = other.getDayOfWeek();
        if (this$dayOfWeek == null ? other$dayOfWeek != null : !((Object)this$dayOfWeek).equals(other$dayOfWeek)) {
            return false;
        }
        Property<DayInMonth> this$dayInMonth = this.getDayInMonth();
        Property<DayInMonth> other$dayInMonth = other.getDayInMonth();
        return !(this$dayInMonth == null ? other$dayInMonth != null : !((Object)this$dayInMonth).equals(other$dayInMonth));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DayWeekInMonth;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        Property<DayOfWeek> $dayOfWeek = this.getDayOfWeek();
        result = result * 59 + ($dayOfWeek == null ? 43 : ((Object)$dayOfWeek).hashCode());
        Property<DayInMonth> $dayInMonth = this.getDayInMonth();
        result = result * 59 + ($dayInMonth == null ? 43 : ((Object)$dayInMonth).hashCode());
        return result;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public Property<DayOfWeek> getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public Property<DayInMonth> getDayInMonth() {
        return this.dayInMonth;
    }

    @Generated
    public DayWeekInMonth() {
        this.date = DayWeekInMonth.$default$date();
    }

    public static enum DayInMonth {
        FIRST,
        LAST,
        SECOND,
        THIRD,
        FOURTH;

    }

    @Generated
    public static abstract class DayWeekInMonthBuilder<C extends DayWeekInMonth, B extends DayWeekInMonthBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private Property<DayOfWeek> dayOfWeek;
        @Generated
        private Property<DayInMonth> dayInMonth;

        @Generated
        public B date(String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B dayOfWeek(Property<DayOfWeek> dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return (B)this.self();
        }

        @Generated
        public B dayInMonth(Property<DayInMonth> dayInMonth) {
            this.dayInMonth = dayInMonth;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DayWeekInMonth.DayWeekInMonthBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", dayOfWeek=" + String.valueOf(this.dayOfWeek) + ", dayInMonth=" + String.valueOf(this.dayInMonth) + ")";
        }
    }

    @Generated
    private static final class DayWeekInMonthBuilderImpl
    extends DayWeekInMonthBuilder<DayWeekInMonth, DayWeekInMonthBuilderImpl> {
        @Generated
        private DayWeekInMonthBuilderImpl() {
        }

        @Override
        @Generated
        protected DayWeekInMonthBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DayWeekInMonth build() {
            return new DayWeekInMonth(this);
        }
    }
}

