/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.data;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.GreaterThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.LessThanOrEqualTo;
import io.kestra.plugin.core.dashboard.data.IData;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public interface IExecutions
extends IData<Fields> {
    @Override
    default public List<AbstractFilter<Fields>> whereWithGlobalFilters(List<QueryFilter> filters, ZonedDateTime startDate, ZonedDateTime endDate, List<AbstractFilter<Fields>> where) {
        ArrayList<AbstractFilter<Fields>> updatedWhere;
        ArrayList<AbstractFilter<Fields>> arrayList = updatedWhere = where != null ? new ArrayList<AbstractFilter<Fields>>(where) : new ArrayList();
        if (filters != null) {
            List<QueryFilter> stateFilters;
            List<QueryFilter> flowFilters;
            List<QueryFilter> labelFilters;
            List<QueryFilter> namespaceFilters = filters.stream().filter(f -> f.field().equals((Object)QueryFilter.Field.NAMESPACE)).toList();
            if (!namespaceFilters.isEmpty()) {
                updatedWhere.removeIf(filter -> ((Fields)((Object)((Object)filter.getField()))).equals((Object)Fields.NAMESPACE));
                namespaceFilters.forEach(f -> updatedWhere.add(f.toDashboardFilterBuilder(Fields.NAMESPACE, f.value())));
            }
            if (!(labelFilters = filters.stream().filter(f -> f.field().equals((Object)QueryFilter.Field.LABELS)).toList()).isEmpty()) {
                updatedWhere.removeIf(filter -> ((Fields)((Object)((Object)filter.getField()))).equals((Object)Fields.LABELS));
                labelFilters.forEach(f -> updatedWhere.add(((Contains.ContainsBuilder)((Contains.ContainsBuilder)Contains.builder().field(Fields.LABELS)).value(f.value())).build()));
            }
            if (!(flowFilters = filters.stream().filter(f -> f.field().equals((Object)QueryFilter.Field.FLOW_ID)).toList()).isEmpty()) {
                updatedWhere.removeIf(filter -> ((Fields)((Object)((Object)filter.getField()))).equals((Object)Fields.FLOW_ID));
                flowFilters.forEach(f -> updatedWhere.add(f.toDashboardFilterBuilder(Fields.FLOW_ID, f.value())));
            }
            if (!(stateFilters = filters.stream().filter(f -> f.field().equals((Object)QueryFilter.Field.STATE)).toList()).isEmpty()) {
                updatedWhere.removeIf(filter -> ((Fields)((Object)((Object)filter.getField()))).equals((Object)Fields.STATE));
                stateFilters.forEach(f -> updatedWhere.add(f.toDashboardFilterBuilder(Fields.STATE, f.value())));
            }
        }
        if (startDate != null || endDate != null) {
            if (startDate != null) {
                updatedWhere.removeIf(f -> ((Fields)((Object)((Object)f.getField()))).equals((Object)Fields.START_DATE));
                updatedWhere.add(((GreaterThanOrEqualTo.GreaterThanOrEqualToBuilder)((GreaterThanOrEqualTo.GreaterThanOrEqualToBuilder)GreaterThanOrEqualTo.builder().field(Fields.START_DATE)).value(startDate.toInstant())).build());
            }
            if (endDate != null) {
                updatedWhere.removeIf(f -> ((Fields)((Object)((Object)f.getField()))).equals((Object)Fields.END_DATE));
                updatedWhere.add(((LessThanOrEqualTo.LessThanOrEqualToBuilder)((LessThanOrEqualTo.LessThanOrEqualToBuilder)LessThanOrEqualTo.builder().field(Fields.END_DATE)).value(endDate.toInstant())).build());
            }
        }
        return updatedWhere;
    }

    public static enum Fields {
        ID,
        NAMESPACE,
        FLOW_ID,
        FLOW_REVISION,
        STATE,
        DURATION,
        LABELS,
        START_DATE,
        END_DATE,
        TRIGGER_EXECUTION_ID;

    }
}

