/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

@Schema(title="Sleep task, wait for a specified duration before proceeding.")
@Plugin(examples={@Example(full=true, code={"id: sleep\nnamespace: company.team\n\ntasks:\n  - id: sleep\n    type: io.kestra.plugin.core.flow.Sleep\n    duration: \"PT5S\"\n"})})
public class Sleep
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="Duration to sleep", description="The time duration in ISO-8601 format (e.g., `PT5S` for 5 seconds).")
    @NotNull
    private Property<Duration> duration;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        Duration durationRendered = runContext.render(this.duration).as(Duration.class).orElseThrow();
        runContext.logger().info("Waiting for {}", (Object)durationRendered);
        TimeUnit.MILLISECONDS.sleep(durationRendered.toMillis());
        return null;
    }

    @Generated
    protected Sleep(SleepBuilder<?, ?> b) {
        super(b);
        this.duration = b.duration;
    }

    @Generated
    public static SleepBuilder<?, ?> builder() {
        return new SleepBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Sleep(super=" + super.toString() + ", duration=" + String.valueOf(this.getDuration()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sleep)) {
            return false;
        }
        Sleep other = (Sleep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Duration> this$duration = this.getDuration();
        Property<Duration> other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sleep;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Duration> $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        return result;
    }

    @Generated
    public Property<Duration> getDuration() {
        return this.duration;
    }

    @Generated
    public Sleep() {
    }

    @Generated
    public static abstract class SleepBuilder<C extends Sleep, B extends SleepBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<Duration> duration;

        @Generated
        public B duration(Property<Duration> duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Sleep.SleepBuilder(super=" + super.toString() + ", duration=" + String.valueOf(this.duration) + ")";
        }
    }

    @Generated
    private static final class SleepBuilderImpl
    extends SleepBuilder<Sleep, SleepBuilderImpl> {
        @Generated
        private SleepBuilderImpl() {
        }

        @Override
        @Generated
        protected SleepBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Sleep build() {
            return new Sleep(this);
        }
    }
}

