/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.TruthUtils;
import io.kestra.plugin.core.http.AbstractHttp;
import io.kestra.plugin.core.http.HttpInterface;
import io.kestra.plugin.core.http.Request;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Trigger a flow based on an HTTP response")
@Plugin(examples={@Example(title="Send a Slack alert if the price is below a certain threshold. The flow will be triggered every 30 seconds until the condition is met. Then, the `stopAfter` property will disable the trigger to avoid unnecessary API calls and alerts.", full=true, code={"id: http_price_alert\nnamespace: company.team\n\ntasks:\n  - id: send_slack_alert\n    type: io.kestra.plugin.notifications.slack.SlackIncomingWebhook\n    url: \"{{ secret('SLACK_WEBHOOK') }}\"\n    payload: |\n      {\n        \"channel\": \"#price-alerts\",\n        \"text\": \"The price is now: {{ json(trigger.body).price }}\"\n      }\n\ntriggers:\n  - id: http\n    type: io.kestra.plugin.core.http.Trigger\n    uri: https://fakestoreapi.com/products/1\n    responseCondition: \"{{ json(response.body).price <= 110 }}\"\n    interval: PT30S\n    stopAfter:\n      - SUCCESS\n"}), @Example(title="Trigger a flow if an HTTP endpoint returns a status code equals to 200", full=true, code={"id: http_trigger\nnamespace: company.team\n\ntasks:\n  - id: log_response\n    type: io.kestra.plugin.core.log.Log\n    message: '{{ trigger.body }}'\n\ntriggers:\n  - id: http\n    type: io.kestra.plugin.core.http.Trigger\n    uri: https://api.chucknorris.io/jokes/random\n    responseCondition: \"{{ response.statusCode == 200 }}\"\n    stopAfter:\n      - SUCCESS\n"})}, aliases={"io.kestra.plugin.fs.http.Trigger"})
public class Trigger
extends AbstractTrigger
implements PollingTriggerInterface,
HttpInterface,
TriggerOutput<Request.Output> {
    private final Duration interval;
    @Schema(title="The condition on the HTTP response to trigger a flow, which can be any expression that evaluates to a boolean value.", description="The condition will be evaluated after calling the HTTP endpoint; it can use the response itself to determine whether to start a flow or not.\nThe following variables are available when evaluating the condition:\n- `response.statusCode`: the response HTTP status code\n- `response.body`: the response body as a string\n- `response.headers`: the response headers\n\nBoolean coercion allows 0, -0, null and '' to evaluate to false, all other values will evaluate to true.\n\nThe condition will be evaluated before any 'generic trigger conditions' that can be configured via the `conditions` property.\n")
    @NotNull
    private Property<String> responseCondition;
    @NotNull
    private Property<String> uri;
    private Property<String> method;
    private Property<String> body;
    private Property<Map<String, Object>> formData;
    private Property<String> contentType;
    private Property<Map<CharSequence, CharSequence>> headers;
    private HttpConfiguration options;
    @Schema(title="If true, the HTTP response body will be automatically encrypted and decrypted in the outputs if encryption is configured.", description="When true, the `encryptedBody` output will be filled, otherwise the `body` output will be filled.")
    private Property<Boolean> encryptBody;
    @Deprecated
    private SslOptions sslOptions;

    @Override
    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        RunContext runContext = conditionContext.getRunContext();
        Logger logger = runContext.logger();
        if (this.options == null) {
            this.options = HttpConfiguration.builder().build();
        }
        this.options.setAllowFailed(Property.ofValue(true));
        this.options.setSsl(this.options.getSsl() != null ? this.options.getSsl() : this.sslOptions);
        AbstractHttp request = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().uri(this.uri)).method(this.method)).body(this.body)).formData(this.formData)).contentType(this.contentType)).headers(this.headers)).options(this.options)).encryptBody(this.encryptBody)).build();
        Request.Output output = ((Request)request).run(runContext);
        logger.debug("{} respond with status code '{}'", (Object)output.getUri(), (Object)output.getCode());
        Object body = runContext.render(this.encryptBody).as(Boolean.class).orElseThrow() != false ? runContext.decrypt(output.getEncryptedBody().getValue()) : output.getBody();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("statusCode", output.getCode());
        response.put("body", body);
        response.put("headers", output.getHeaders());
        Map<String, Object> responseVariables = Map.of("response", response);
        String renderedCondition = runContext.render(this.responseCondition).as(String.class, responseVariables).orElse(null);
        if (TruthUtils.isTruthy(renderedCondition)) {
            Execution execution = TriggerService.generateExecution((AbstractTrigger)this, conditionContext, context, output);
            return Optional.of(execution);
        }
        return Optional.empty();
    }

    @Deprecated
    public void sslOptions(SslOptions sslOptions) {
        if (this.options == null) {
            this.options = HttpConfiguration.builder().build();
        }
        this.sslOptions = sslOptions;
        this.options.setSsl(sslOptions);
    }

    @Generated
    private static Duration $default$interval() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static Property<String> $default$responseCondition() {
        return Property.ofExpression("{{ response.statusCode < 400 }}");
    }

    @Generated
    private static Property<String> $default$method() {
        return Property.ofValue("GET");
    }

    @Generated
    private static Property<String> $default$contentType() {
        return Property.ofValue("application/json");
    }

    @Generated
    private static Property<Boolean> $default$encryptBody() {
        return Property.ofValue(false);
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super(b);
        this.interval = b.interval$set ? b.interval$value : Trigger.$default$interval();
        this.responseCondition = b.responseCondition$set ? b.responseCondition$value : Trigger.$default$responseCondition();
        this.uri = b.uri;
        this.method = b.method$set ? b.method$value : Trigger.$default$method();
        this.body = b.body;
        this.formData = b.formData;
        this.contentType = b.contentType$set ? b.contentType$value : Trigger.$default$contentType();
        this.headers = b.headers;
        this.options = b.options;
        this.encryptBody = b.encryptBody$set ? b.encryptBody$value : Trigger.$default$encryptBody();
        this.sslOptions = b.sslOptions;
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", responseCondition=" + String.valueOf(this.getResponseCondition()) + ", uri=" + String.valueOf(this.getUri()) + ", method=" + String.valueOf(this.getMethod()) + ", body=" + String.valueOf(this.getBody()) + ", formData=" + String.valueOf(this.getFormData()) + ", contentType=" + String.valueOf(this.getContentType()) + ", headers=" + String.valueOf(this.getHeaders()) + ", options=" + String.valueOf(this.getOptions()) + ", encryptBody=" + String.valueOf(this.getEncryptBody()) + ", sslOptions=" + String.valueOf(this.getSslOptions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        Property<String> this$responseCondition = this.getResponseCondition();
        Property<String> other$responseCondition = other.getResponseCondition();
        if (this$responseCondition == null ? other$responseCondition != null : !((Object)this$responseCondition).equals(other$responseCondition)) {
            return false;
        }
        Property<String> this$uri = this.getUri();
        Property<String> other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Property<String> this$method = this.getMethod();
        Property<String> other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Property<String> this$body = this.getBody();
        Property<String> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Property<Map<String, Object>> this$formData = this.getFormData();
        Property<Map<String, Object>> other$formData = other.getFormData();
        if (this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData)) {
            return false;
        }
        Property<String> this$contentType = this.getContentType();
        Property<String> other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        Property<Map<CharSequence, CharSequence>> this$headers = this.getHeaders();
        Property<Map<CharSequence, CharSequence>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        HttpConfiguration this$options = this.getOptions();
        HttpConfiguration other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        Property<Boolean> this$encryptBody = this.getEncryptBody();
        Property<Boolean> other$encryptBody = other.getEncryptBody();
        if (this$encryptBody == null ? other$encryptBody != null : !((Object)this$encryptBody).equals(other$encryptBody)) {
            return false;
        }
        SslOptions this$sslOptions = this.getSslOptions();
        SslOptions other$sslOptions = other.getSslOptions();
        return !(this$sslOptions == null ? other$sslOptions != null : !this$sslOptions.equals(other$sslOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        Property<String> $responseCondition = this.getResponseCondition();
        result = result * 59 + ($responseCondition == null ? 43 : ((Object)$responseCondition).hashCode());
        Property<String> $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Property<String> $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Property<String> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Property<Map<String, Object>> $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
        Property<String> $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        Property<Map<CharSequence, CharSequence>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        HttpConfiguration $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        Property<Boolean> $encryptBody = this.getEncryptBody();
        result = result * 59 + ($encryptBody == null ? 43 : ((Object)$encryptBody).hashCode());
        SslOptions $sslOptions = this.getSslOptions();
        result = result * 59 + ($sslOptions == null ? 43 : $sslOptions.hashCode());
        return result;
    }

    @Override
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public Property<String> getResponseCondition() {
        return this.responseCondition;
    }

    @Override
    @Generated
    public Property<String> getUri() {
        return this.uri;
    }

    @Override
    @Generated
    public Property<String> getMethod() {
        return this.method;
    }

    @Override
    @Generated
    public Property<String> getBody() {
        return this.body;
    }

    @Override
    @Generated
    public Property<Map<String, Object>> getFormData() {
        return this.formData;
    }

    @Override
    @Generated
    public Property<String> getContentType() {
        return this.contentType;
    }

    @Override
    @Generated
    public Property<Map<CharSequence, CharSequence>> getHeaders() {
        return this.headers;
    }

    @Override
    @Generated
    public HttpConfiguration getOptions() {
        return this.options;
    }

    @Generated
    public Property<Boolean> getEncryptBody() {
        return this.encryptBody;
    }

    @Override
    @Deprecated
    @Generated
    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    @Generated
    public Trigger() {
        this.interval = Trigger.$default$interval();
        this.responseCondition = Trigger.$default$responseCondition();
        this.method = Trigger.$default$method();
        this.contentType = Trigger.$default$contentType();
        this.encryptBody = Trigger.$default$encryptBody();
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private boolean responseCondition$set;
        @Generated
        private Property<String> responseCondition$value;
        @Generated
        private Property<String> uri;
        @Generated
        private boolean method$set;
        @Generated
        private Property<String> method$value;
        @Generated
        private Property<String> body;
        @Generated
        private Property<Map<String, Object>> formData;
        @Generated
        private boolean contentType$set;
        @Generated
        private Property<String> contentType$value;
        @Generated
        private Property<Map<CharSequence, CharSequence>> headers;
        @Generated
        private HttpConfiguration options;
        @Generated
        private boolean encryptBody$set;
        @Generated
        private Property<Boolean> encryptBody$value;
        @Generated
        private SslOptions sslOptions;

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B responseCondition(Property<String> responseCondition) {
            this.responseCondition$value = responseCondition;
            this.responseCondition$set = true;
            return (B)this.self();
        }

        @Generated
        public B uri(Property<String> uri) {
            this.uri = uri;
            return (B)this.self();
        }

        @Generated
        public B method(Property<String> method) {
            this.method$value = method;
            this.method$set = true;
            return (B)this.self();
        }

        @Generated
        public B body(Property<String> body) {
            this.body = body;
            return (B)this.self();
        }

        @Generated
        public B formData(Property<Map<String, Object>> formData) {
            this.formData = formData;
            return (B)this.self();
        }

        @Generated
        public B contentType(Property<String> contentType) {
            this.contentType$value = contentType;
            this.contentType$set = true;
            return (B)this.self();
        }

        @Generated
        public B headers(Property<Map<CharSequence, CharSequence>> headers) {
            this.headers = headers;
            return (B)this.self();
        }

        @Generated
        public B options(HttpConfiguration options) {
            this.options = options;
            return (B)this.self();
        }

        @Generated
        public B encryptBody(Property<Boolean> encryptBody) {
            this.encryptBody$value = encryptBody;
            this.encryptBody$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B sslOptions(SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", responseCondition$value=" + String.valueOf(this.responseCondition$value) + ", uri=" + String.valueOf(this.uri) + ", method$value=" + String.valueOf(this.method$value) + ", body=" + String.valueOf(this.body) + ", formData=" + String.valueOf(this.formData) + ", contentType$value=" + String.valueOf(this.contentType$value) + ", headers=" + String.valueOf(this.headers) + ", options=" + String.valueOf(this.options) + ", encryptBody$value=" + String.valueOf(this.encryptBody$value) + ", sslOptions=" + String.valueOf(this.sslOptions) + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

