/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.exceptions.ResourceExpiredException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.kv.KVValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Retrieve a value of a KV pair by a key.")
@Plugin(examples={@Example(title="Get value for `my_variable` key in `dev` namespace and fail if it's not present. Note that you can accomplish the same using the `kv()` Pebble function, e.g. `{{kv('my_variable')}}`.", full=true, code={"id: kv_store_get\nnamespace: company.team\n\ntasks:\n  - id: kv_get\n    type: io.kestra.plugin.core.kv.Get\n    key: my_variable\n    namespace: company # the current namespace is used by default\n    errorOnMissing: true\n"})})
public class Get
extends Task
implements RunnableTask<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Get.class);
    @NotNull
    @Schema(title="The key for which to get the value")
    private Property<String> key;
    @NotNull
    @Schema(title="The namespace from which to retrieve the KV pair")
    private Property<String> namespace;
    @NotNull
    @Schema(title="Flag specifying whether to fail if there is no value for the given key")
    private Property<Boolean> errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Optional<KVValue> value;
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElse(null);
        String flowNamespace = runContext.flowInfo().namespace();
        String renderedKey = runContext.render(this.key).as(String.class).orElse(null);
        if (Objects.equals(renderedNamespace, flowNamespace)) {
            value = this.getValueWithInheritance(runContext, flowNamespace, renderedKey);
        } else {
            FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
            flowService.checkAllowedNamespace(runContext.flowInfo().tenantId(), renderedNamespace, runContext.flowInfo().tenantId(), runContext.flowInfo().namespace());
            value = runContext.namespaceKv(renderedNamespace).getValue(renderedKey);
        }
        if (Boolean.TRUE.equals(runContext.render(this.errorOnMissing).as(Boolean.class).orElseThrow()) && value.isEmpty()) {
            throw new NoSuchElementException("No value found for key '" + renderedKey + "' in namespace '" + renderedNamespace + "' and `errorOnMissing` is set to true");
        }
        return Output.builder().value(value.map(KVValue::value).orElse(null)).build();
    }

    private Optional<KVValue> getValueWithInheritance(RunContext runContext, String flowNamespace, String renderedKey) throws IOException, ResourceExpiredException {
        Optional<KVValue> value = Optional.empty();
        KVStoreService kvStoreService = (KVStoreService)((DefaultRunContext)runContext).getApplicationContext().getBean(KVStoreService.class);
        String inheritedNamespace = flowNamespace;
        while (value.isEmpty()) {
            value = kvStoreService.get(runContext.flowInfo().tenantId(), inheritedNamespace, flowNamespace).getValue(renderedKey);
            if (!inheritedNamespace.contains(".")) {
                return value;
            }
            inheritedNamespace = inheritedNamespace.substring(0, inheritedNamespace.lastIndexOf(46));
        }
        return value;
    }

    @Generated
    private static Property<String> $default$namespace() {
        return Property.ofExpression("{{ flow.namespace }}");
    }

    @Generated
    private static Property<Boolean> $default$errorOnMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected Get(GetBuilder<?, ?> b) {
        super(b);
        this.key = b.key;
        this.namespace = b.namespace$set ? b.namespace$value : Get.$default$namespace();
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Get.$default$errorOnMissing();
    }

    @Generated
    public static GetBuilder<?, ?> builder() {
        return new GetBuilderImpl();
    }

    @Generated
    public GetBuilder<?, ?> toBuilder() {
        return new GetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getKey() {
        return this.key;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<Boolean> getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Get() {
        this.namespace = Get.$default$namespace();
        this.errorOnMissing = Get.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Value retrieved for the key", description="This can be of any type and will stay the same as when it was set.")
        private final Object value;

        @ConstructorProperties(value={"value"})
        @Generated
        Output(Object value) {
            this.value = value;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Object value;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(Object value) {
                this.value = value;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value);
            }

            @Generated
            public String toString() {
                return "Get.Output.OutputBuilder(value=" + String.valueOf(this.value) + ")";
            }
        }
    }

    @Generated
    public static abstract class GetBuilder<C extends Get, B extends GetBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> key;
        @Generated
        private boolean namespace$set;
        @Generated
        private Property<String> namespace$value;
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Property<Boolean> errorOnMissing$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Get instance, GetBuilder<?, ?> b) {
            b.key(instance.key);
            b.namespace(instance.namespace);
            b.errorOnMissing(instance.errorOnMissing);
        }

        @Generated
        public B key(Property<String> key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return (B)this.self();
        }

        @Generated
        public B errorOnMissing(Property<Boolean> errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Get.GetBuilder(super=" + super.toString() + ", key=" + String.valueOf(this.key) + ", namespace$value=" + String.valueOf(this.namespace$value) + ", errorOnMissing$value=" + String.valueOf(this.errorOnMissing$value) + ")";
        }
    }

    @Generated
    private static final class GetBuilderImpl
    extends GetBuilder<Get, GetBuilderImpl> {
        @Generated
        private GetBuilderImpl() {
        }

        @Override
        @Generated
        protected GetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Get build() {
            return new Get(this);
        }
    }
}

