/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import com.cronutils.utils.VisibleForTesting;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.ValidationErrorException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.utils.ListUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Delete expired keys globally for a specific namespace.", description="This task will delete expired keys from the Kestra KV store. By default, it will only delete expired keys, but you can choose to delete all keys by setting `expiredOnly` to false. You can also filter keys by a specific pattern and choose to include child namespaces.")
@Plugin(examples={@Example(title="Delete expired keys globally for a specific namespace, with or without including child namespaces.", full=true, code={"id: purge_kv_store\nnamespace: system\n\ntasks:\n  - id: purge_kv\n    type: io.kestra.plugin.core.kv.PurgeKV\n    expiredOnly: true\n    namespaces:\n      - company\n    includeChildNamespaces: true\n"})})
public class PurgeKV
extends Task
implements RunnableTask<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurgeKV.class);
    @Schema(title="Key pattern, e.g. 'AI_*'", description="Delete only keys matching the glob pattern.")
    private Property<String> keyPattern;
    @Schema(title="List of namespaces to delete keys from", description="If not set, all namespaces will be considered. Can't be used with `namespacePattern` - use one or the other.")
    private Property<List<String>> namespaces;
    @Schema(title="Glob pattern for the namespaces to delete keys from", description="If not set (e.g., AI_*), all namespaces will be considered. Can't be used with `namespaces` - use one or the other.")
    private Property<String> namespacePattern;
    @Schema(title="Delete only expired keys", description="Defaults to true.")
    private Property<Boolean> expiredOnly;
    @Schema(title="Delete keys from child namespaces", description="Defaults to true. This means that if you set `namespaces` to `company`, it will also delete keys from `company.team`, `company.data`, etc.")
    private Property<Boolean> includeChildNamespaces;

    @Override
    public Output run(RunContext runContext) throws Exception {
        List<String> kvNamespaces = this.findNamespaces(runContext);
        boolean purgeExpiredOnly = runContext.render(this.expiredOnly).as(Boolean.class).orElse(true);
        String renderedKeyPattern = runContext.render(this.keyPattern).as(String.class).orElse(null);
        boolean keyFiltering = StringUtils.isNotBlank((CharSequence)renderedKeyPattern);
        runContext.logger().info("purging {} namespaces: {}", (Object)kvNamespaces.size(), kvNamespaces);
        AtomicLong count = new AtomicLong();
        for (String ns : kvNamespaces) {
            KVStore kvStore = runContext.namespaceKv(ns);
            ArrayList<KVEntry> kvEntries = new ArrayList<KVEntry>();
            List<KVEntry> allKvEntries = kvStore.listAll();
            if (purgeExpiredOnly) {
                Instant now = Instant.now();
                kvEntries.addAll(allKvEntries.stream().filter(kv -> kv.expirationDate() != null && kv.expirationDate().isBefore(now)).toList());
            } else {
                kvEntries.addAll(allKvEntries);
            }
            List<String> keys = kvEntries.stream().map(KVEntry::key).filter(key -> {
                if (keyFiltering) {
                    return FilenameUtils.wildcardMatch((String)key, (String)renderedKeyPattern);
                }
                return true;
            }).toList();
            for (String key2 : keys) {
                kvStore.delete(key2);
            }
            count.addAndGet(keys.size());
        }
        runContext.logger().info("purged {} keys", (Object)count.get());
        return Output.builder().size(count.get()).build();
    }

    @VisibleForTesting
    protected List<String> findNamespaces(RunContext runContext) throws IllegalVariableEvaluationException {
        String tenantId = runContext.flowInfo().tenantId();
        String currentNamespace = runContext.flowInfo().namespace();
        FlowRepositoryInterface flowRepositoryInterface = (FlowRepositoryInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowRepositoryInterface.class);
        List<String> distinctNamespaces = flowRepositoryInterface.findDistinctNamespace(tenantId);
        List<String> renderedNamespaces = runContext.render(this.namespaces).asList(String.class);
        String renderedNamespacePattern = runContext.render(this.namespacePattern).as(String.class).orElse(null);
        if (!ListUtils.isEmpty(renderedNamespaces) && StringUtils.isNotBlank((CharSequence)renderedNamespacePattern)) {
            throw new ValidationErrorException(List.of("Properties `namespaces` and `namespacePattern` can't be used at the same time \u2014 use one or the other."));
        }
        ArrayList<String> kvNamespaces = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)renderedNamespacePattern)) {
            kvNamespaces.addAll(distinctNamespaces.stream().filter(ns -> FilenameUtils.wildcardMatch((String)ns, (String)renderedNamespacePattern)).toList());
        } else if (!renderedNamespaces.isEmpty()) {
            if (runContext.render(this.includeChildNamespaces).as(Boolean.class).orElse(true).booleanValue()) {
                kvNamespaces.addAll(distinctNamespaces.stream().filter(ns -> {
                    for (String renderedNamespace : renderedNamespaces) {
                        if (!ns.startsWith(renderedNamespace)) continue;
                        return true;
                    }
                    return false;
                }).toList());
            } else {
                kvNamespaces.addAll(distinctNamespaces.stream().filter(ns -> {
                    for (String renderedNamespace : renderedNamespaces) {
                        if (!ns.equals(renderedNamespace)) continue;
                        return true;
                    }
                    return false;
                }).toList());
            }
        } else {
            kvNamespaces.addAll(distinctNamespaces);
        }
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        for (String ns2 : kvNamespaces) {
            flowService.checkAllowedNamespace(tenantId, ns2, tenantId, currentNamespace);
        }
        return kvNamespaces;
    }

    @Generated
    private static Property<Boolean> $default$expiredOnly() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<Boolean> $default$includeChildNamespaces() {
        return Property.ofValue(true);
    }

    @Generated
    protected PurgeKV(PurgeKVBuilder<?, ?> b) {
        super(b);
        this.keyPattern = b.keyPattern;
        this.namespaces = b.namespaces;
        this.namespacePattern = b.namespacePattern;
        this.expiredOnly = b.expiredOnly$set ? b.expiredOnly$value : PurgeKV.$default$expiredOnly();
        this.includeChildNamespaces = b.includeChildNamespaces$set ? b.includeChildNamespaces$value : PurgeKV.$default$includeChildNamespaces();
    }

    @Generated
    public static PurgeKVBuilder<?, ?> builder() {
        return new PurgeKVBuilderImpl();
    }

    @Generated
    public PurgeKVBuilder<?, ?> toBuilder() {
        return new PurgeKVBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getKeyPattern() {
        return this.keyPattern;
    }

    @Generated
    public Property<List<String>> getNamespaces() {
        return this.namespaces;
    }

    @Generated
    public Property<String> getNamespacePattern() {
        return this.namespacePattern;
    }

    @Generated
    public Property<Boolean> getExpiredOnly() {
        return this.expiredOnly;
    }

    @Generated
    public Property<Boolean> getIncludeChildNamespaces() {
        return this.includeChildNamespaces;
    }

    @Generated
    public PurgeKV() {
        this.expiredOnly = PurgeKV.$default$expiredOnly();
        this.includeChildNamespaces = PurgeKV.$default$includeChildNamespaces();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The number of purged KV pairs")
        private Long size;

        @ConstructorProperties(value={"size"})
        @Generated
        Output(Long size) {
            this.size = size;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size);
            }

            @Generated
            public String toString() {
                return "PurgeKV.Output.OutputBuilder(size=" + this.size + ")";
            }
        }
    }

    @Generated
    public static abstract class PurgeKVBuilder<C extends PurgeKV, B extends PurgeKVBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> keyPattern;
        @Generated
        private Property<List<String>> namespaces;
        @Generated
        private Property<String> namespacePattern;
        @Generated
        private boolean expiredOnly$set;
        @Generated
        private Property<Boolean> expiredOnly$value;
        @Generated
        private boolean includeChildNamespaces$set;
        @Generated
        private Property<Boolean> includeChildNamespaces$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PurgeKVBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PurgeKV instance, PurgeKVBuilder<?, ?> b) {
            b.keyPattern(instance.keyPattern);
            b.namespaces(instance.namespaces);
            b.namespacePattern(instance.namespacePattern);
            b.expiredOnly(instance.expiredOnly);
            b.includeChildNamespaces(instance.includeChildNamespaces);
        }

        @Generated
        public B keyPattern(Property<String> keyPattern) {
            this.keyPattern = keyPattern;
            return (B)this.self();
        }

        @Generated
        public B namespaces(Property<List<String>> namespaces) {
            this.namespaces = namespaces;
            return (B)this.self();
        }

        @Generated
        public B namespacePattern(Property<String> namespacePattern) {
            this.namespacePattern = namespacePattern;
            return (B)this.self();
        }

        @Generated
        public B expiredOnly(Property<Boolean> expiredOnly) {
            this.expiredOnly$value = expiredOnly;
            this.expiredOnly$set = true;
            return (B)this.self();
        }

        @Generated
        public B includeChildNamespaces(Property<Boolean> includeChildNamespaces) {
            this.includeChildNamespaces$value = includeChildNamespaces;
            this.includeChildNamespaces$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PurgeKV.PurgeKVBuilder(super=" + super.toString() + ", keyPattern=" + String.valueOf(this.keyPattern) + ", namespaces=" + String.valueOf(this.namespaces) + ", namespacePattern=" + String.valueOf(this.namespacePattern) + ", expiredOnly$value=" + String.valueOf(this.expiredOnly$value) + ", includeChildNamespaces$value=" + String.valueOf(this.includeChildNamespaces$value) + ")";
        }
    }

    @Generated
    private static final class PurgeKVBuilderImpl
    extends PurgeKVBuilder<PurgeKV, PurgeKVBuilderImpl> {
        @Generated
        private PurgeKVBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeKVBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PurgeKV build() {
            return new PurgeKV(this);
        }
    }
}

