/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.log;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Schema(title="Log a message to the console.")
@Plugin(examples={@Example(code={"level: DEBUG", "message: \"{{ task.id }} > {{ taskrun.startDate }}\""}), @Example(title="Log one or more messages to the console.", full=true, code={"id: hello_world\nnamespace: company.team\n\ntasks:\n  - id: greeting\n    type: io.kestra.plugin.core.log.Log\n    message:\n      - Kestra team wishes you a great day \ud83d\udc4b\n      - If you need some help, reach out via Slack"})}, aliases={"io.kestra.core.tasks.log.Log"})
public class Log
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="One or more message(s) to be sent to the backend as logs", description="It can be a string or an array of strings.", oneOf={String.class, String[].class})
    @NotNull
    @PluginProperty(dynamic=true)
    private Object message;
    @Schema(title="The level on which the message should be logged. Note that this is different from the core `logLevel` property which sets the minimum log level to be persisted in the backend database. The `level` property is used to determine the log level of the message emitted by the Log task, while `logLevel` is used to filter which logs should be stored in the backend. Both properties can be used together to control the log level of the message emitted by the task and the logs that are persisted in the backend. If not specified, the `level` defaults to `INFO`.")
    private Property<Level> level;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        Level renderedLevel = runContext.render(this.level).as(Level.class).orElseThrow();
        Object object = this.message;
        if (object instanceof String) {
            String stringValue = (String)object;
            render = runContext.render(stringValue);
            this.log(logger, renderedLevel, (String)render);
        } else {
            render = this.message;
            if (render instanceof Collection) {
                Collection collectionValue;
                Collection messages = collectionValue = (Collection)render;
                messages.forEach(Rethrow.throwConsumer(message -> {
                    String render = runContext.render((String)message);
                    this.log(logger, renderedLevel, render);
                }));
            } else {
                throw new IllegalArgumentException("Invalid message type '" + String.valueOf(this.message.getClass()) + "'");
            }
        }
        return null;
    }

    public void log(Logger logger, Level level, String message) {
        switch (level) {
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log level '" + this.level.toString() + "'");
            }
        }
    }

    @Generated
    private static Property<Level> $default$level() {
        return Property.ofValue(Level.INFO);
    }

    @Generated
    protected Log(LogBuilder<?, ?> b) {
        super(b);
        this.message = b.message;
        this.level = b.level$set ? b.level$value : Log.$default$level();
    }

    @Generated
    public static LogBuilder<?, ?> builder() {
        return new LogBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Log(super=" + super.toString() + ", message=" + String.valueOf(this.getMessage()) + ", level=" + String.valueOf(this.getLevel()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Property<Level> this$level = this.getLevel();
        Property<Level> other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !((Object)this$level).equals(other$level));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Log;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Property<Level> $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        return result;
    }

    @Generated
    public Object getMessage() {
        return this.message;
    }

    @Generated
    public Property<Level> getLevel() {
        return this.level;
    }

    @Generated
    public Log() {
        this.level = Log.$default$level();
    }

    @Generated
    public static abstract class LogBuilder<C extends Log, B extends LogBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object message;
        @Generated
        private boolean level$set;
        @Generated
        private Property<Level> level$value;

        @Generated
        public B message(Object message) {
            this.message = message;
            return (B)this.self();
        }

        @Generated
        public B level(Property<Level> level) {
            this.level$value = level;
            this.level$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Log.LogBuilder(super=" + super.toString() + ", message=" + String.valueOf(this.message) + ", level$value=" + String.valueOf(this.level$value) + ")";
        }
    }

    @Generated
    private static final class LogBuilderImpl
    extends LogBuilder<Log, LogBuilderImpl> {
        @Generated
        private LogBuilderImpl() {
        }

        @Override
        @Generated
        protected LogBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Log build() {
            return new Log(this);
        }
    }
}

