/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.Namespace;
import io.kestra.core.utils.PathUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Upload one or multiple files to a specific namespace.", description="Use a regex glob pattern or a file path to upload files as Namespace Files. When using a map with the desired file name as key and file path as value, you can also rename or relocate files.")
@Plugin(examples={@Example(title="Upload files generated by a previous task using the `filesMap` property.", full=true, code={"id: upload_files_from_git\nnamespace: company.team\n\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n    uri: https://github.com/kestra-io/scripts/archive/refs/heads/main.zip\n\n  - id: unzip\n    type: io.kestra.plugin.compress.ArchiveDecompress\n    from: \"{{ outputs.download.uri }}\"\n    algorithm: ZIP\n\n  - id: upload\n    type: io.kestra.plugin.core.namespace.UploadFiles\n    filesMap: \"{{ outputs.unzip.files }}\"\n    namespace: \"{{ flow.namespace }}\"\n"}), @Example(title="Upload a folder using a glob pattern. Note that the Regex syntax requires a `glob` pattern inspired by [Apache Ant patterns](https://ant.apache.org/manual/dirtasks.html#patterns). Make sure that your pattern starts with `glob:`, followed by the pattern. For example, use `glob:**/dbt/**` to upload the entire `dbt` folder (with all files and subdirectories) regardless of that folder's location in the directory structure.", full=true, code={"id: upload_dbt_project\nnamespace: company.team\n\ntasks:\n  - id: wdir\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    tasks:\n      - id: git_clone\n        type: io.kestra.plugin.git.Clone\n        url: https://github.com/kestra-io/dbt-example\n        branch: master\n\n      - id: upload\n        type: io.kestra.plugin.core.namespace.UploadFiles\n        files:\n          - \"glob:**/dbt/**\"\n        namespace: \"{{ flow.namespace }}\"\n"}), @Example(title="Upload a specific file and rename it.", full=true, code={"id: upload_a_file\nnamespace: company.team\n\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n    uri: https://github.com/kestra-io/scripts/archive/refs/heads/main.zip\n\n  - id: unzip\n    type: io.kestra.plugin.compress.ArchiveDecompress\n    from: \"{{ outputs.download.uri }}\"\n    algorithm: ZIP\n\n  - id: upload\n    type: io.kestra.plugin.core.namespace.UploadFiles\n    filesMap:\n      LICENCE: \"{{ outputs.unzip.files['scripts-main/LICENSE'] }}\"\n    namespace: \"{{ flow.namespace }}\"\n"})})
public class UploadFiles
extends Task
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="The namespace to which the files will be uploaded")
    private Property<String> namespace;
    @Schema(title="A list of Regex that match files in the current directory", description="This should be a list of Regex matching the [Apache Ant patterns](https://ant.apache.org/manual/dirtasks.html#patterns).It's primarily intended to be used with the `WorkingDirectory` task")
    private Property<List<String>> files;
    @Schema(title="A map of key-value pairs where the key is the filename and the value is the URI of the file to upload.", description="This should be a map of URI, with the key being the filename that will be upload and the key the URI.This property is intended to be used with the output files of other tasks. Many Kestra tasks, incl. all Downloads tasks, output a map of files so that you can directly pass the output property to this task e.g. [outputFiles in the S3 Downloads task](https://kestra.io/plugins/plugin-aws/tasks/s3/io.kestra.plugin.aws.s3.downloads#outputfiles) or the [files in the Archive Decompress task](https://kestra.io/plugins/plugin-compress/tasks/io.kestra.plugin.compress.archivedecompress#files).", anyOf={Map.class, String.class})
    @PluginProperty(dynamic=true)
    private Object filesMap;
    @Schema(title="The destination folder", description="Required when providing a list of files.")
    private Property<String> destination;
    @Schema(title="Which action to take when uploading a file that already exists", description="Can be one of the following options: OVERWRITE, ERROR or SKIP. Default is OVERWRITE.")
    private Property<Namespace.Conflicts> conflict;

    @Override
    public Output run(RunContext runContext) throws Exception {
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        String renderedNamespace = this.namespace != null ? runContext.render(this.namespace).as(String.class).orElseThrow() : flowInfo.namespace();
        String renderedDestination = PathUtil.checkLeadingSlash(runContext.render(this.destination).as(String.class).orElseThrow());
        Namespace storageNamespace = runContext.storage().namespace(renderedNamespace);
        if (this.files == null && this.filesMap == null) {
            throw new IllegalArgumentException("files or filesMap is required");
        }
        List<String> renderedFiles = runContext.render(this.files).asList(String.class);
        if (!renderedFiles.isEmpty()) {
            this.uploadFiles(runContext, renderedFiles, storageNamespace, renderedDestination);
        }
        if (this.filesMap != null) {
            Map readFilesMap;
            Object object = this.filesMap;
            if (object instanceof String) {
                String stringValue = (String)object;
                String renderedFilesMap = runContext.render(stringValue);
                readFilesMap = (Map)JacksonMapper.ofJson().readValue(renderedFilesMap, Map.class);
            } else {
                readFilesMap = (Map)this.filesMap;
            }
            this.uploadFilesMap(runContext, readFilesMap, storageNamespace, renderedDestination);
        }
        return Output.builder().build();
    }

    private void uploadFiles(RunContext runContext, List<String> files, Namespace storageNamespace, String destination) throws IllegalVariableEvaluationException, IOException, URISyntaxException {
        files = runContext.render(files);
        for (Path path : runContext.workingDir().findAllFilesMatching(files)) {
            File file = path.toFile();
            Path resolve = Paths.get("/", new String[0]).resolve(runContext.workingDir().path().relativize(file.toPath()));
            Path targetFilePath = Path.of(destination, resolve.toString());
            storageNamespace.putFile(targetFilePath, (InputStream)new FileInputStream(file), runContext.render(this.conflict).as(Namespace.Conflicts.class).orElseThrow());
        }
    }

    private void uploadFilesMap(RunContext runContext, Map<String, Object> filesMap, Namespace storageNamespace, String destination) throws IOException, URISyntaxException, IllegalVariableEvaluationException {
        Map<String, Object> renderedMap = runContext.render(filesMap);
        for (Map.Entry<String, Object> entry : renderedMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof String) {
                String targetFilePath = key;
                if (value instanceof String) {
                    String stringSourceFileURI = (String)value;
                    URI sourceFileURI = URI.create(stringSourceFileURI);
                    if (!runContext.storage().isFileExist(sourceFileURI)) continue;
                    storageNamespace.putFile(Path.of(destination + targetFilePath, new String[0]), runContext.storage().getFile(sourceFileURI), runContext.render(this.conflict).as(Namespace.Conflicts.class).orElseThrow());
                    continue;
                }
            }
            throw new IllegalArgumentException("filesMap must be a Map<String, String>");
        }
    }

    @Generated
    private static Property<String> $default$destination() {
        return Property.ofValue("/");
    }

    @Generated
    private static Property<Namespace.Conflicts> $default$conflict() {
        return Property.ofValue(Namespace.Conflicts.OVERWRITE);
    }

    @Generated
    protected UploadFiles(UploadFilesBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.files = b.files;
        this.filesMap = b.filesMap;
        this.destination = b.destination$set ? b.destination$value : UploadFiles.$default$destination();
        this.conflict = b.conflict$set ? b.conflict$value : UploadFiles.$default$conflict();
    }

    @Generated
    public static UploadFilesBuilder<?, ?> builder() {
        return new UploadFilesBuilderImpl();
    }

    @Generated
    public UploadFilesBuilder<?, ?> toBuilder() {
        return new UploadFilesBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<List<String>> getFiles() {
        return this.files;
    }

    @Generated
    public Object getFilesMap() {
        return this.filesMap;
    }

    @Generated
    public Property<String> getDestination() {
        return this.destination;
    }

    @Generated
    public Property<Namespace.Conflicts> getConflict() {
        return this.conflict;
    }

    @Generated
    public UploadFiles() {
        this.destination = UploadFiles.$default$destination();
        this.conflict = UploadFiles.$default$conflict();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private final Map<String, URI> files;

        @ConstructorProperties(value={"files"})
        @Generated
        Output(Map<String, URI> files) {
            this.files = files;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, URI> getFiles() {
            return this.files;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, URI> files;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder files(Map<String, URI> files) {
                this.files = files;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.files);
            }

            @Generated
            public String toString() {
                return "UploadFiles.Output.OutputBuilder(files=" + String.valueOf(this.files) + ")";
            }
        }
    }

    @Generated
    public static abstract class UploadFilesBuilder<C extends UploadFiles, B extends UploadFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<List<String>> files;
        @Generated
        private Object filesMap;
        @Generated
        private boolean destination$set;
        @Generated
        private Property<String> destination$value;
        @Generated
        private boolean conflict$set;
        @Generated
        private Property<Namespace.Conflicts> conflict$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UploadFilesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(UploadFiles instance, UploadFilesBuilder<?, ?> b) {
            b.namespace(instance.namespace);
            b.files(instance.files);
            b.filesMap(instance.filesMap);
            b.destination(instance.destination);
            b.conflict(instance.conflict);
        }

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B files(Property<List<String>> files) {
            this.files = files;
            return (B)this.self();
        }

        @Generated
        public B filesMap(Object filesMap) {
            this.filesMap = filesMap;
            return (B)this.self();
        }

        @Generated
        public B destination(Property<String> destination) {
            this.destination$value = destination;
            this.destination$set = true;
            return (B)this.self();
        }

        @Generated
        public B conflict(Property<Namespace.Conflicts> conflict) {
            this.conflict$value = conflict;
            this.conflict$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UploadFiles.UploadFilesBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", files=" + String.valueOf(this.files) + ", filesMap=" + String.valueOf(this.filesMap) + ", destination$value=" + String.valueOf(this.destination$value) + ", conflict$value=" + String.valueOf(this.conflict$value) + ")";
        }
    }

    @Generated
    private static final class UploadFilesBuilderImpl
    extends UploadFilesBuilder<UploadFiles, UploadFilesBuilderImpl> {
        @Generated
        private UploadFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadFiles build() {
            return new UploadFiles(this);
        }
    }
}

