/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.state;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.state.AbstractState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.util.Map;
import lombok.Generated;

@Schema(title="Get a state from the state store (Deprecated).")
@Plugin(examples={@Example(title="Get the default state file for the current flow.", code={"id: get_state", "type: io.kestra.plugin.core.state.Get"}, full=true), @Example(title="Get the `myState` state for the current flow.", code={"id: get_state", "type: io.kestra.plugin.core.state.Get", "name: myState"}, full=true)}, aliases={"io.kestra.core.tasks.states.Get"})
public class Get
extends AbstractState
implements RunnableTask<Output> {
    @Schema(title="Raise an error if the state file is not found.")
    private final Property<Boolean> errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Map<String, Object> data;
        try {
            data = this.get(runContext);
        }
        catch (FileNotFoundException e) {
            if (Boolean.TRUE.equals(runContext.render(this.errorOnMissing).as(Boolean.class).orElseThrow())) {
                throw e;
            }
            data = Map.of();
        }
        return Output.builder().count(data.size()).data(data).build();
    }

    @Generated
    private static Property<Boolean> $default$errorOnMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected Get(GetBuilder<?, ?> b) {
        super((AbstractState.AbstractStateBuilder<?, ?>)b);
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Get.$default$errorOnMissing();
    }

    @Generated
    public static GetBuilder<?, ?> builder() {
        return new GetBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Get(super=" + super.toString() + ", errorOnMissing=" + String.valueOf(this.getErrorOnMissing()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Get)) {
            return false;
        }
        Get other = (Get)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$errorOnMissing = this.getErrorOnMissing();
        Property<Boolean> other$errorOnMissing = other.getErrorOnMissing();
        return !(this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Get;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        return result;
    }

    @Generated
    public Property<Boolean> getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Get() {
        this.errorOnMissing = Get.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of properties found in the state")
        private final int count;
        @Schema(title="The data extracted from the state")
        private final Map<String, Object> data;

        @ConstructorProperties(value={"count", "data"})
        @Generated
        Output(int count, Map<String, Object> data) {
            this.count = count;
            this.data = data;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public Map<String, Object> getData() {
            return this.data;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private int count;
            @Generated
            private Map<String, Object> data;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder count(int count) {
                this.count = count;
                return this;
            }

            @Generated
            public OutputBuilder data(Map<String, Object> data) {
                this.data = data;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.count, this.data);
            }

            @Generated
            public String toString() {
                return "Get.Output.OutputBuilder(count=" + this.count + ", data=" + String.valueOf(this.data) + ")";
            }
        }
    }

    @Generated
    public static abstract class GetBuilder<C extends Get, B extends GetBuilder<C, B>>
    extends AbstractState.AbstractStateBuilder<C, B> {
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Property<Boolean> errorOnMissing$value;

        @Generated
        public B errorOnMissing(Property<Boolean> errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Get.GetBuilder(super=" + super.toString() + ", errorOnMissing$value=" + String.valueOf(this.errorOnMissing$value) + ")";
        }
    }

    @Generated
    private static final class GetBuilderImpl
    extends GetBuilder<Get, GetBuilderImpl> {
        @Generated
        private GetBuilderImpl() {
        }

        @Override
        @Generated
        protected GetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Get build() {
            return new Get(this);
        }
    }
}

