/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.TruthUtils;
import io.micronaut.core.util.functional.ThrowingFunction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import lombok.Generated;

@Schema(title="Filter a file by retaining only the items that match a given expression.")
@Plugin(examples={@Example(full=true, code={"tasks:\n   - id: filter\n     type: io.kestra.plugin.core.storage.FilterItems\n     from: \"{{ inputs.file }}\"\n     filterCondition: \" {{ value == null }}\"\n     filterType: EXCLUDE\n     errorOrNullBehavior: EXCLUDE\n"})}, aliases={"io.kestra.core.tasks.storages.FilterItems"})
public class FilterItems
extends Task
implements RunnableTask<Output> {
    @Schema(title="The file to be filtered")
    @NotNull
    @PluginProperty(internalStorageURI=true)
    private Property<String> from;
    @Schema(title="The 'pebble' expression used to match items to be included or excluded", description="The 'pebble' expression should return a BOOLEAN value (i.e. `true` or `false`). Values `0`, `-0`, and `\"\"` are interpreted as `false`. Otherwise, any non empty value will be interpreted as `true`.")
    @PluginProperty
    @NotNull
    private String filterCondition;
    @Schema(title="Specifies the action to perform with items that match the `filterCondition` predicate", description="Use `INCLUDE` to pass the item through, or `EXCLUDE` to drop the items.")
    private Property<FilterType> filterType;
    @Schema(title="Specifies the behavior when the expression fails to be evaluated on an item or returns `null`.", description="Use `FAIL` to throw the exception and fail the task, `INCLUDE` to pass the item through, or `EXCLUDE` to drop the item.")
    private Property<ErrorOrNullBehavior> errorOrNullBehavior;

    @Override
    public Output run(RunContext runContext) throws Exception {
        URI from = new URI(runContext.render(this.from).as(String.class).orElseThrow());
        PebbleExpressionPredicate predicate = this.getExpressionPredication(runContext);
        Path path = runContext.workingDir().createTempFile(".ion");
        long processedItemsTotal = 0L;
        long droppedItemsTotal = 0L;
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
             BufferedReader reader = this.newBufferedReader(runContext, from);){
            String item;
            while ((item = reader.readLine()) != null) {
                IllegalVariableEvaluationException exception = null;
                Boolean match = null;
                try {
                    match = predicate.apply(item);
                }
                catch (IllegalVariableEvaluationException e) {
                    exception = e;
                }
                FilterType action = runContext.render(this.filterType).as(FilterType.class).orElseThrow();
                if (match == null) {
                    switch (runContext.render(this.errorOrNullBehavior).as(ErrorOrNullBehavior.class).orElseThrow().ordinal()) {
                        case 0: {
                            if (exception != null) {
                                throw exception;
                            }
                            throw new IllegalVariableEvaluationException(String.format("Expression `%s` return `null` on item `%s`", this.filterCondition, item));
                        }
                        case 1: {
                            action = FilterType.INCLUDE;
                            break;
                        }
                        case 2: {
                            action = FilterType.EXCLUDE;
                        }
                    }
                    match = true;
                }
                if (!match.booleanValue()) {
                    action = action.reverse();
                }
                switch (action.ordinal()) {
                    case 0: {
                        writer.write(item);
                        writer.newLine();
                        break;
                    }
                    case 1: {
                        ++droppedItemsTotal;
                    }
                }
                ++processedItemsTotal;
            }
        }
        URI uri = runContext.storage().putFile(path.toFile());
        return Output.builder().uri(uri).processedItemsTotal(processedItemsTotal).droppedItemsTotal(droppedItemsTotal).build();
    }

    private PebbleExpressionPredicate getExpressionPredication(RunContext runContext) {
        return new PebbleExpressionPredicate(runContext, this.filterCondition);
    }

    private BufferedReader newBufferedReader(RunContext runContext, URI objectURI) throws IOException {
        InputStream is = runContext.storage().getFile(objectURI);
        return new BufferedReader(new InputStreamReader(is));
    }

    @Generated
    private static Property<FilterType> $default$filterType() {
        return Property.ofValue(FilterType.INCLUDE);
    }

    @Generated
    private static Property<ErrorOrNullBehavior> $default$errorOrNullBehavior() {
        return Property.ofValue(ErrorOrNullBehavior.FAIL);
    }

    @Generated
    protected FilterItems(FilterItemsBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.filterCondition = b.filterCondition;
        this.filterType = b.filterType$set ? b.filterType$value : FilterItems.$default$filterType();
        this.errorOrNullBehavior = b.errorOrNullBehavior$set ? b.errorOrNullBehavior$value : FilterItems.$default$errorOrNullBehavior();
    }

    @Generated
    public static FilterItemsBuilder<?, ?> builder() {
        return new FilterItemsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "FilterItems(super=" + super.toString() + ", from=" + String.valueOf(this.getFrom()) + ", filterCondition=" + this.getFilterCondition() + ", filterType=" + String.valueOf(this.getFilterType()) + ", errorOrNullBehavior=" + String.valueOf(this.getErrorOrNullBehavior()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterItems)) {
            return false;
        }
        FilterItems other = (FilterItems)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$from = this.getFrom();
        Property<String> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        String this$filterCondition = this.getFilterCondition();
        String other$filterCondition = other.getFilterCondition();
        if (this$filterCondition == null ? other$filterCondition != null : !this$filterCondition.equals(other$filterCondition)) {
            return false;
        }
        Property<FilterType> this$filterType = this.getFilterType();
        Property<FilterType> other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)this$filterType).equals(other$filterType)) {
            return false;
        }
        Property<ErrorOrNullBehavior> this$errorOrNullBehavior = this.getErrorOrNullBehavior();
        Property<ErrorOrNullBehavior> other$errorOrNullBehavior = other.getErrorOrNullBehavior();
        return !(this$errorOrNullBehavior == null ? other$errorOrNullBehavior != null : !((Object)this$errorOrNullBehavior).equals(other$errorOrNullBehavior));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilterItems;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        String $filterCondition = this.getFilterCondition();
        result = result * 59 + ($filterCondition == null ? 43 : $filterCondition.hashCode());
        Property<FilterType> $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)$filterType).hashCode());
        Property<ErrorOrNullBehavior> $errorOrNullBehavior = this.getErrorOrNullBehavior();
        result = result * 59 + ($errorOrNullBehavior == null ? 43 : ((Object)$errorOrNullBehavior).hashCode());
        return result;
    }

    @Generated
    public Property<String> getFrom() {
        return this.from;
    }

    @Generated
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @Generated
    public Property<FilterType> getFilterType() {
        return this.filterType;
    }

    @Generated
    public Property<ErrorOrNullBehavior> getErrorOrNullBehavior() {
        return this.errorOrNullBehavior;
    }

    @Generated
    public FilterItems() {
        this.filterType = FilterItems.$default$filterType();
        this.errorOrNullBehavior = FilterItems.$default$errorOrNullBehavior();
    }

    private static class PebbleExpressionPredicate
    implements ThrowingFunction<String, Boolean, Exception> {
        protected static final ObjectMapper MAPPER = JacksonMapper.ofIon();
        private final RunContext runContext;
        private final String expression;

        public Boolean apply(String data) throws Exception {
            try {
                String rendered = this.extract(MAPPER.readTree(data));
                return rendered == null ? null : Boolean.valueOf(TruthUtils.isTruthy(rendered.trim()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public PebbleExpressionPredicate(RunContext runContext, String expression) {
            this.runContext = runContext;
            this.expression = expression;
        }

        public String extract(JsonNode jsonNode) throws Exception {
            Map map = (Map)MAPPER.convertValue((Object)jsonNode, Map.class);
            return this.runContext.render(this.expression, (Map<String, Object>)map);
        }
    }

    public static enum FilterType {
        INCLUDE,
        EXCLUDE;


        public FilterType reverse() {
            return this.equals((Object)INCLUDE) ? EXCLUDE : INCLUDE;
        }
    }

    public static enum ErrorOrNullBehavior {
        FAIL,
        INCLUDE,
        EXCLUDE;

    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The filtered file URI")
        private final URI uri;
        @Schema(title="The total number of items that were processed by the task")
        private final Long processedItemsTotal;
        @Schema(title="The total number of items that were dropped by the task")
        private final Long droppedItemsTotal;

        @ConstructorProperties(value={"uri", "processedItemsTotal", "droppedItemsTotal"})
        @Generated
        Output(URI uri, Long processedItemsTotal, Long droppedItemsTotal) {
            this.uri = uri;
            this.processedItemsTotal = processedItemsTotal;
            this.droppedItemsTotal = droppedItemsTotal;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getProcessedItemsTotal() {
            return this.processedItemsTotal;
        }

        @Generated
        public Long getDroppedItemsTotal() {
            return this.droppedItemsTotal;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Long processedItemsTotal;
            @Generated
            private Long droppedItemsTotal;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder processedItemsTotal(Long processedItemsTotal) {
                this.processedItemsTotal = processedItemsTotal;
                return this;
            }

            @Generated
            public OutputBuilder droppedItemsTotal(Long droppedItemsTotal) {
                this.droppedItemsTotal = droppedItemsTotal;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.processedItemsTotal, this.droppedItemsTotal);
            }

            @Generated
            public String toString() {
                return "FilterItems.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ", processedItemsTotal=" + this.processedItemsTotal + ", droppedItemsTotal=" + this.droppedItemsTotal + ")";
            }
        }
    }

    @Generated
    public static abstract class FilterItemsBuilder<C extends FilterItems, B extends FilterItemsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> from;
        @Generated
        private String filterCondition;
        @Generated
        private boolean filterType$set;
        @Generated
        private Property<FilterType> filterType$value;
        @Generated
        private boolean errorOrNullBehavior$set;
        @Generated
        private Property<ErrorOrNullBehavior> errorOrNullBehavior$value;

        @Generated
        public B from(Property<String> from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B filterCondition(String filterCondition) {
            this.filterCondition = filterCondition;
            return (B)this.self();
        }

        @Generated
        public B filterType(Property<FilterType> filterType) {
            this.filterType$value = filterType;
            this.filterType$set = true;
            return (B)this.self();
        }

        @Generated
        public B errorOrNullBehavior(Property<ErrorOrNullBehavior> errorOrNullBehavior) {
            this.errorOrNullBehavior$value = errorOrNullBehavior;
            this.errorOrNullBehavior$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FilterItems.FilterItemsBuilder(super=" + super.toString() + ", from=" + String.valueOf(this.from) + ", filterCondition=" + this.filterCondition + ", filterType$value=" + String.valueOf(this.filterType$value) + ", errorOrNullBehavior$value=" + String.valueOf(this.errorOrNullBehavior$value) + ")";
        }
    }

    @Generated
    private static final class FilterItemsBuilderImpl
    extends FilterItemsBuilder<FilterItems, FilterItemsBuilderImpl> {
        @Generated
        private FilterItemsBuilderImpl() {
        }

        @Override
        @Generated
        protected FilterItemsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FilterItems build() {
            return new FilterItems(this);
        }
    }
}

