/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Toggle a trigger: enable or disable it.")
@Plugin(examples={@Example(title="Toggle a trigger on flow input.", full=true, code={"id: trigger_toggle\nnamespace: company.team\n\ninputs:\n  - id: toggle\n    type: BOOL\n    defaults: true\n\ntasks:\n  - id: if\n    type: io.kestra.plugin.core.flow.If\n    condition: \"{{inputs.toggle}}\"\n    then:\n      - id: enable\n        type: io.kestra.plugin.core.trigger.Toggle\n        trigger: schedule\n        enabled: true\n    else:\n      - id: disable\n        type: io.kestra.plugin.core.trigger.Toggle\n        trigger: schedule\n        enabled: false\n  - id: log\n    type: io.kestra.plugin.core.log.Log\n    message: Hello World\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"* * * * *\"\n"})}, aliases={"io.kestra.core.tasks.trigger.Toggle"})
public class Toggle
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="The flow identifier of the trigger to toggle", description="If not set, the current flow identifier will be used.")
    @PluginProperty(dynamic=true)
    private String flowId;
    @Schema(title="The namespace of the flow of the trigger to toggle", description="If not set, the current flow namespace will be used.")
    @PluginProperty(dynamic=true)
    private String namespace;
    @Schema(title="The identifier of the trigger to toggle")
    @NotNull
    @PluginProperty(dynamic=true)
    private String trigger;
    @Schema(title="Whether to enable or disable the trigger")
    @NotNull
    @PluginProperty
    private Boolean enabled;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        Map flowVariables = (Map)runContext.getVariables().get("flow");
        String realNamespace = this.namespace == null ? (String)flowVariables.get("namespace") : runContext.render(this.namespace);
        String realFlowId = this.flowId == null ? (String)flowVariables.get("id") : runContext.render(this.flowId);
        String realTrigger = runContext.render(this.trigger);
        ApplicationContext applicationContext = ((DefaultRunContext)runContext).getApplicationContext();
        FlowMetaStoreInterface flowExecutor = (FlowMetaStoreInterface)applicationContext.getBean(FlowMetaStoreInterface.class);
        flowExecutor.findByIdFromTask(runContext.flowInfo().tenantId(), realNamespace, realFlowId, Optional.empty(), runContext.flowInfo().tenantId(), (String)flowVariables.get("namespace"), (String)flowVariables.get("id")).orElseThrow(() -> new IllegalArgumentException("Unable to find flow " + realNamespace + "." + realFlowId + ". Make sure the flow exists and the current execution is authorized to access it."));
        Object triggerContext = ((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)TriggerContext.builder().tenantId(runContext.flowInfo().tenantId())).namespace(realNamespace)).flowId(realFlowId)).triggerId(realTrigger)).build();
        TriggerRepositoryInterface triggerRepository = (TriggerRepositoryInterface)applicationContext.getBean(TriggerRepositoryInterface.class);
        TriggerContext currentTrigger = triggerRepository.findLast((TriggerContext)triggerContext).orElseThrow(() -> new IllegalArgumentException("Unable to find trigger " + realTrigger + " for the flow " + realNamespace + "." + realFlowId));
        currentTrigger = ((Trigger.TriggerBuilder)currentTrigger.toBuilder().disabled(this.enabled == false)).build();
        QueueInterface triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        triggerQueue.emit(currentTrigger);
        return null;
    }

    @Generated
    private static Boolean $default$enabled() {
        return false;
    }

    @Generated
    protected Toggle(ToggleBuilder<?, ?> b) {
        super(b);
        this.flowId = b.flowId;
        this.namespace = b.namespace;
        this.trigger = b.trigger;
        this.enabled = b.enabled$set ? b.enabled$value : Toggle.$default$enabled();
    }

    @Generated
    public static ToggleBuilder<?, ?> builder() {
        return new ToggleBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Toggle(super=" + super.toString() + ", flowId=" + this.getFlowId() + ", namespace=" + this.getNamespace() + ", trigger=" + this.getTrigger() + ", enabled=" + this.getEnabled() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Toggle)) {
            return false;
        }
        Toggle other = (Toggle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$trigger = this.getTrigger();
        String other$trigger = other.getTrigger();
        return !(this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Toggle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        return result;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getTrigger() {
        return this.trigger;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public Toggle() {
        this.enabled = Toggle.$default$enabled();
    }

    @Generated
    public static abstract class ToggleBuilder<C extends Toggle, B extends ToggleBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String flowId;
        @Generated
        private String namespace;
        @Generated
        private String trigger;
        @Generated
        private boolean enabled$set;
        @Generated
        private Boolean enabled$value;

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B trigger(String trigger) {
            this.trigger = trigger;
            return (B)this.self();
        }

        @Generated
        public B enabled(Boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Toggle.ToggleBuilder(super=" + super.toString() + ", flowId=" + this.flowId + ", namespace=" + this.namespace + ", trigger=" + this.trigger + ", enabled$value=" + this.enabled$value + ")";
        }
    }

    @Generated
    private static final class ToggleBuilderImpl
    extends ToggleBuilder<Toggle, ToggleBuilderImpl> {
        @Generated
        private ToggleBuilderImpl() {
        }

        @Override
        @Generated
        protected ToggleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Toggle build() {
            return new Toggle(this);
        }
    }
}

