/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.kestra.core.annotations.Retryable;
import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.annotation.DefaultRetryPredicate;
import io.micronaut.retry.annotation.RetryPredicate;
import io.micronaut.retry.event.RetryEvent;
import io.micronaut.retry.intercept.MutableRetryState;
import io.micronaut.retry.intercept.SimpleRetry;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OverrideRetryInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(OverrideRetryInterceptor.class);
    private final ApplicationEventPublisher<RetryEvent> eventPublisher;

    public OverrideRetryInterceptor(ApplicationEventPublisher<RetryEvent> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public int getOrder() {
        return InterceptPhase.RETRY.getPosition();
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Optional opt = context.findAnnotation(Retryable.class);
        if (opt.isEmpty()) {
            return context.proceed();
        }
        AnnotationValue retry = (AnnotationValue)opt.get();
        SimpleRetry retryState = new SimpleRetry(retry.get((CharSequence)"attempts", Integer.class).orElse(5).intValue(), retry.get((CharSequence)"multiplier", Double.class).orElse(2.0).doubleValue(), retry.get((CharSequence)"delay", Duration.class).orElse(Duration.ofSeconds(1L)), (Duration)retry.get((CharSequence)"maxDelay", Duration.class).orElse(null), (RetryPredicate)new DefaultRetryPredicate(OverrideRetryInterceptor.resolveIncludes((AnnotationValue<Retryable>)retry, "includes"), OverrideRetryInterceptor.resolveIncludes((AnnotationValue<Retryable>)retry, "excludes")), Throwable.class, 0.0);
        MutableConvertibleValues attrs = context.getAttributes();
        attrs.put((CharSequence)RetryState.class.getName(), (Object)retry);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)ConversionService.SHARED);
        try {
            retryState.open();
            Object result = this.retrySync(context, (MutableRetryState)retryState, interceptedMethod);
            switch (interceptedMethod.resultType()) {
                case SYNCHRONOUS: {
                    retryState.close(null);
                    return result;
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private static List<Class<? extends Throwable>> resolveIncludes(AnnotationValue<Retryable> retry, String includes) {
        Class[] values = retry.classValues(includes);
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    private Object retrySync(MethodInvocationContext<Object, Object> context, MutableRetryState retryState, InterceptedMethod interceptedMethod) {
        boolean firstCall = true;
        while (true) {
            try {
                if (firstCall) {
                    firstCall = false;
                    return interceptedMethod.interceptResult();
                }
                return interceptedMethod.interceptResult((Interceptor)this);
            }
            catch (Throwable e) {
                if (!retryState.canRetry(e)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", context);
                    }
                    retryState.close(e);
                    throw e;
                }
                long delayMillis = retryState.nextDelay();
                try {
                    if (this.eventPublisher != null) {
                        try {
                            this.eventPublisher.publishEvent((Object)new RetryEvent(context, (RetryState)retryState, e));
                        }
                        catch (Exception e1) {
                            LOG.error("Error occurred publishing RetryEvent: " + e1.getMessage(), (Throwable)e1);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delayMillis, e.getMessage()});
                    }
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException e1) {
                    throw e;
                }
            }
        }
    }
}

