/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.configurations;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.client.configurations.AbstractAuthConfiguration;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class BasicAuthConfiguration
extends AbstractAuthConfiguration {
    @NotNull
    @JsonInclude
    protected AbstractAuthConfiguration.AuthType type;
    @Schema(title="The username for HTTP basic authentication.")
    private Property<String> username;
    @Schema(title="The password for HTTP basic authentication.")
    private Property<String> password;

    @Override
    public void configure(HttpClientBuilder builder, RunContext runContext) throws IllegalVariableEvaluationException {
        byte[] encoded = Base64.getEncoder().encode(((String)runContext.render(this.getUsername()).as(String.class).orElse(null) + ":" + (String)runContext.render(this.getPassword()).as(String.class).orElse(null)).getBytes(StandardCharsets.UTF_8));
        builder.addRequestInterceptorFirst((request, entity, context) -> request.setHeader((Header)new BasicHeader("Authorization", (Object)("Basic " + new String(encoded, StandardCharsets.UTF_8)))));
    }

    @Generated
    private static AbstractAuthConfiguration.AuthType $default$type() {
        return AbstractAuthConfiguration.AuthType.BASIC;
    }

    @Generated
    protected BasicAuthConfiguration(BasicAuthConfigurationBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : BasicAuthConfiguration.$default$type();
        this.username = b.username;
        this.password = b.password;
    }

    @Generated
    public static BasicAuthConfigurationBuilder<?, ?> builder() {
        return new BasicAuthConfigurationBuilderImpl();
    }

    @Generated
    public BasicAuthConfigurationBuilder<?, ?> toBuilder() {
        return new BasicAuthConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public AbstractAuthConfiguration.AuthType getType() {
        return this.type;
    }

    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Generated
    public Property<String> getPassword() {
        return this.password;
    }

    @Generated
    public BasicAuthConfiguration() {
        this.type = BasicAuthConfiguration.$default$type();
    }

    @Generated
    public static abstract class BasicAuthConfigurationBuilder<C extends BasicAuthConfiguration, B extends BasicAuthConfigurationBuilder<C, B>>
    extends AbstractAuthConfiguration.AbstractAuthConfigurationBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private AbstractAuthConfiguration.AuthType type$value;
        @Generated
        private Property<String> username;
        @Generated
        private Property<String> password;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BasicAuthConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BasicAuthConfiguration instance, BasicAuthConfigurationBuilder<?, ?> b) {
            b.type(instance.type);
            b.username(instance.username);
            b.password(instance.password);
        }

        @Generated
        public B type(AbstractAuthConfiguration.AuthType type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B username(Property<String> username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(Property<String> password) {
            this.password = password;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BasicAuthConfiguration.BasicAuthConfigurationBuilder(super=" + super.toString() + ", type$value=" + String.valueOf((Object)this.type$value) + ", username=" + String.valueOf(this.username) + ", password=" + String.valueOf(this.password) + ")";
        }
    }

    @Generated
    private static final class BasicAuthConfigurationBuilderImpl
    extends BasicAuthConfigurationBuilder<BasicAuthConfiguration, BasicAuthConfigurationBuilderImpl> {
        @Generated
        private BasicAuthConfigurationBuilderImpl() {
        }

        @Override
        @Generated
        protected BasicAuthConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BasicAuthConfiguration build() {
            return new BasicAuthConfiguration(this);
        }
    }
}

