/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.configurations;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.client.configurations.AbstractAuthConfiguration;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class BearerAuthConfiguration
extends AbstractAuthConfiguration {
    @NotNull
    @JsonInclude
    protected AbstractAuthConfiguration.AuthType type;
    @Schema(title="The token for bearer token authentication.")
    private Property<String> token;

    @Override
    public void configure(HttpClientBuilder builder, RunContext runContext) throws IllegalVariableEvaluationException {
        String renderedToken = runContext.render(this.token).as(String.class).orElse(null);
        builder.addRequestInterceptorFirst((request, entity, context) -> request.setHeader((Header)new BasicHeader("Authorization", (Object)("Bearer " + renderedToken))));
    }

    @Generated
    private static AbstractAuthConfiguration.AuthType $default$type() {
        return AbstractAuthConfiguration.AuthType.BEARER;
    }

    @Generated
    protected BearerAuthConfiguration(BearerAuthConfigurationBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : BearerAuthConfiguration.$default$type();
        this.token = b.token;
    }

    @Generated
    public static BearerAuthConfigurationBuilder<?, ?> builder() {
        return new BearerAuthConfigurationBuilderImpl();
    }

    @Generated
    public BearerAuthConfigurationBuilder<?, ?> toBuilder() {
        return new BearerAuthConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public AbstractAuthConfiguration.AuthType getType() {
        return this.type;
    }

    @Generated
    public Property<String> getToken() {
        return this.token;
    }

    @Generated
    public BearerAuthConfiguration() {
        this.type = BearerAuthConfiguration.$default$type();
    }

    @Generated
    public static abstract class BearerAuthConfigurationBuilder<C extends BearerAuthConfiguration, B extends BearerAuthConfigurationBuilder<C, B>>
    extends AbstractAuthConfiguration.AbstractAuthConfigurationBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private AbstractAuthConfiguration.AuthType type$value;
        @Generated
        private Property<String> token;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BearerAuthConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BearerAuthConfiguration instance, BearerAuthConfigurationBuilder<?, ?> b) {
            b.type(instance.type);
            b.token(instance.token);
        }

        @Generated
        public B type(AbstractAuthConfiguration.AuthType type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B token(Property<String> token) {
            this.token = token;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BearerAuthConfiguration.BearerAuthConfigurationBuilder(super=" + super.toString() + ", type$value=" + String.valueOf((Object)this.type$value) + ", token=" + String.valueOf(this.token) + ")";
        }
    }

    @Generated
    private static final class BearerAuthConfigurationBuilderImpl
    extends BearerAuthConfigurationBuilder<BearerAuthConfiguration, BearerAuthConfigurationBuilderImpl> {
        @Generated
        private BearerAuthConfigurationBuilderImpl() {
        }

        @Override
        @Generated
        protected BearerAuthConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BearerAuthConfiguration build() {
            return new BearerAuthConfiguration(this);
        }
    }
}

