/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.configurations;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.http.client.configurations.AbstractAuthConfiguration;
import io.kestra.core.http.client.configurations.BasicAuthConfiguration;
import io.kestra.core.http.client.configurations.ProxyConfiguration;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.http.client.configurations.TimeoutConfiguration;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.micronaut.logging.LogLevel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=HttpConfigurationBuilder.class)
public class HttpConfiguration {
    @Schema(title="The timeout configuration.")
    @PluginProperty
    private TimeoutConfiguration timeout;
    @Schema(title="The proxy configuration.")
    @PluginProperty
    private ProxyConfiguration proxy;
    @Schema(title="The authentification to use.")
    private AbstractAuthConfiguration auth;
    @Schema(title="The SSL request options")
    private SslOptions ssl;
    @Schema(title="Whether redirects should be followed automatically.")
    private Property<Boolean> followRedirects;
    @Schema(title="If true, allow a failed response code (response code >= 400)")
    private Property<Boolean> allowFailed;
    @Schema(title="List of response code allowed for this request")
    private Property<List<Integer>> allowedResponseCodes;
    @Schema(title="The default charset for the request.")
    private final Property<Charset> defaultCharset;
    @Schema(title="The enabled log.")
    @PluginProperty
    private LoggingType[] logs;
    @Schema(title="The time allowed to establish a connection to the server before failing.")
    @Deprecated
    private final Duration connectTimeout;
    @Schema(title="The maximum time allowed for reading data from the server before failing.")
    @Deprecated
    private final Duration readTimeout;
    @Schema(title="The type of proxy to use.")
    @Deprecated
    private final Proxy.Type proxyType;
    @Schema(title="The address of the proxy server.")
    @Deprecated
    private final String proxyAddress;
    @Schema(title="The port of the proxy server.")
    @Deprecated
    private final Integer proxyPort;
    @Schema(title="The username for proxy authentication.")
    @Deprecated
    private final String proxyUsername;
    @Schema(title="The password for proxy authentication.")
    @Deprecated
    private final String proxyPassword;
    @Schema(title="The username for HTTP basic authentication. Deprecated, use `auth` property with a `BasicAuthConfiguration` instance instead.")
    @Deprecated
    private final String basicAuthUser;
    @Schema(title="The password for HTTP basic authentication. Deprecated, use `auth` property with a `BasicAuthConfiguration` instance instead.")
    @Deprecated
    private final String basicAuthPassword;
    @Schema(title="The log level for the HTTP client.")
    @PluginProperty
    @Deprecated
    private final LogLevel logLevel;
    @Schema(title="The time allowed for a read connection to remain idle before closing it.")
    @Deprecated
    private final Duration readIdleTimeout;
    @Schema(title="The time an idle connection can remain in the client's connection pool before being closed.")
    @Deprecated
    private final Duration connectionPoolIdleTimeout;
    @Schema(title="The maximum content length of the response.")
    @Deprecated
    private final Integer maxContentLength;

    @Generated
    private static Property<Boolean> $default$followRedirects() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<Boolean> $default$allowFailed() {
        return Property.ofValue(false);
    }

    @Generated
    private static Property<Charset> $default$defaultCharset() {
        return Property.ofValue(StandardCharsets.UTF_8);
    }

    @ConstructorProperties(value={"timeout", "proxy", "auth", "ssl", "followRedirects", "allowFailed", "allowedResponseCodes", "defaultCharset", "logs", "connectTimeout", "readTimeout", "proxyType", "proxyAddress", "proxyPort", "proxyUsername", "proxyPassword", "basicAuthUser", "basicAuthPassword", "logLevel", "readIdleTimeout", "connectionPoolIdleTimeout", "maxContentLength"})
    @Generated
    HttpConfiguration(TimeoutConfiguration timeout, ProxyConfiguration proxy, AbstractAuthConfiguration auth, SslOptions ssl, Property<Boolean> followRedirects, Property<Boolean> allowFailed, Property<List<Integer>> allowedResponseCodes, Property<Charset> defaultCharset, LoggingType[] logs, Duration connectTimeout, Duration readTimeout, Proxy.Type proxyType, String proxyAddress, Integer proxyPort, String proxyUsername, String proxyPassword, String basicAuthUser, String basicAuthPassword, LogLevel logLevel, Duration readIdleTimeout, Duration connectionPoolIdleTimeout, Integer maxContentLength) {
        this.timeout = timeout;
        this.proxy = proxy;
        this.auth = auth;
        this.ssl = ssl;
        this.followRedirects = followRedirects;
        this.allowFailed = allowFailed;
        this.allowedResponseCodes = allowedResponseCodes;
        this.defaultCharset = defaultCharset;
        this.logs = logs;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxyType = proxyType;
        this.proxyAddress = proxyAddress;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.basicAuthUser = basicAuthUser;
        this.basicAuthPassword = basicAuthPassword;
        this.logLevel = logLevel;
        this.readIdleTimeout = readIdleTimeout;
        this.connectionPoolIdleTimeout = connectionPoolIdleTimeout;
        this.maxContentLength = maxContentLength;
    }

    @Generated
    public static HttpConfigurationBuilder builder() {
        return new HttpConfigurationBuilder();
    }

    @Generated
    public HttpConfigurationBuilder toBuilder() {
        return new HttpConfigurationBuilder().timeout(this.timeout).proxy(this.proxy).auth(this.auth).ssl(this.ssl).followRedirects(this.followRedirects).allowFailed(this.allowFailed).allowedResponseCodes(this.allowedResponseCodes).defaultCharset(this.defaultCharset).logs(this.logs).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).proxyType(this.proxyType).proxyAddress(this.proxyAddress).proxyPort(this.proxyPort).proxyUsername(this.proxyUsername).proxyPassword(this.proxyPassword).basicAuthUser(this.basicAuthUser).basicAuthPassword(this.basicAuthPassword).logLevel(this.logLevel).readIdleTimeout(this.readIdleTimeout).connectionPoolIdleTimeout(this.connectionPoolIdleTimeout).maxContentLength(this.maxContentLength);
    }

    @Generated
    public TimeoutConfiguration getTimeout() {
        return this.timeout;
    }

    @Generated
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    @Generated
    public AbstractAuthConfiguration getAuth() {
        return this.auth;
    }

    @Generated
    public SslOptions getSsl() {
        return this.ssl;
    }

    @Generated
    public Property<Boolean> getFollowRedirects() {
        return this.followRedirects;
    }

    @Generated
    public Property<Boolean> getAllowFailed() {
        return this.allowFailed;
    }

    @Generated
    public Property<List<Integer>> getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    @Generated
    public Property<Charset> getDefaultCharset() {
        return this.defaultCharset;
    }

    @Generated
    public LoggingType[] getLogs() {
        return this.logs;
    }

    @Deprecated
    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    @Generated
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Deprecated
    @Generated
    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    @Deprecated
    @Generated
    public String getProxyAddress() {
        return this.proxyAddress;
    }

    @Deprecated
    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Deprecated
    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Deprecated
    @Generated
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Deprecated
    @Generated
    public String getBasicAuthUser() {
        return this.basicAuthUser;
    }

    @Deprecated
    @Generated
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Deprecated
    @Generated
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Deprecated
    @Generated
    public Duration getReadIdleTimeout() {
        return this.readIdleTimeout;
    }

    @Deprecated
    @Generated
    public Duration getConnectionPoolIdleTimeout() {
        return this.connectionPoolIdleTimeout;
    }

    @Deprecated
    @Generated
    public Integer getMaxContentLength() {
        return this.maxContentLength;
    }

    @Generated
    public void setSsl(SslOptions ssl) {
        this.ssl = ssl;
    }

    @Generated
    public void setAllowFailed(Property<Boolean> allowFailed) {
        this.allowFailed = allowFailed;
    }

    @Generated
    public void setAllowedResponseCodes(Property<List<Integer>> allowedResponseCodes) {
        this.allowedResponseCodes = allowedResponseCodes;
    }

    public static enum LoggingType {
        REQUEST_HEADERS,
        REQUEST_BODY,
        RESPONSE_HEADERS,
        RESPONSE_BODY;

    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class HttpConfigurationBuilder {
        @Generated
        private TimeoutConfiguration timeout;
        @Generated
        private ProxyConfiguration proxy;
        @Generated
        private AbstractAuthConfiguration auth;
        @Generated
        private SslOptions ssl;
        @Generated
        private boolean followRedirects$set;
        @Generated
        private Property<Boolean> followRedirects$value;
        @Generated
        private boolean allowFailed$set;
        @Generated
        private Property<Boolean> allowFailed$value;
        @Generated
        private Property<List<Integer>> allowedResponseCodes;
        @Generated
        private boolean defaultCharset$set;
        @Generated
        private Property<Charset> defaultCharset$value;
        @Generated
        private LoggingType[] logs;
        @Generated
        private Duration connectTimeout;
        @Generated
        private Duration readTimeout;
        @Generated
        private Proxy.Type proxyType;
        @Generated
        private String proxyAddress;
        @Generated
        private Integer proxyPort;
        @Generated
        private String proxyUsername;
        @Generated
        private String proxyPassword;
        @Generated
        private String basicAuthUser;
        @Generated
        private String basicAuthPassword;
        @Generated
        private LogLevel logLevel;
        @Generated
        private Duration readIdleTimeout;
        @Generated
        private Duration connectionPoolIdleTimeout;
        @Generated
        private Integer maxContentLength;

        @Deprecated
        public HttpConfigurationBuilder connectTimeout(Duration connectTimeout) {
            if (this.timeout == null) {
                this.timeout = TimeoutConfiguration.builder().build();
            }
            this.timeout = this.timeout.toBuilder().connectTimeout(Property.ofValue(connectTimeout)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder readTimeout(Duration readTimeout) {
            if (this.timeout == null) {
                this.timeout = TimeoutConfiguration.builder().build();
            }
            this.timeout = this.timeout.toBuilder().readIdleTimeout(Property.ofValue(readTimeout)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder proxyType(Proxy.Type proxyType) {
            if (this.proxy == null) {
                this.proxy = ProxyConfiguration.builder().build();
            }
            this.proxy = this.proxy.toBuilder().type(Property.ofValue(proxyType)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder proxyAddress(String proxyAddress) {
            if (this.proxy == null) {
                this.proxy = ProxyConfiguration.builder().build();
            }
            this.proxy = this.proxy.toBuilder().address(Property.ofValue(proxyAddress)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder proxyPort(Integer proxyPort) {
            if (this.proxy == null) {
                this.proxy = ProxyConfiguration.builder().build();
            }
            this.proxy = this.proxy.toBuilder().port(Property.ofValue(proxyPort)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder proxyUsername(String proxyUsername) {
            if (this.proxy == null) {
                this.proxy = ProxyConfiguration.builder().build();
            }
            this.proxy = this.proxy.toBuilder().username(Property.ofValue(proxyUsername)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder proxyPassword(String proxyPassword) {
            if (this.proxy == null) {
                this.proxy = ProxyConfiguration.builder().build();
            }
            this.proxy = this.proxy.toBuilder().password(Property.ofValue(proxyPassword)).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder basicAuthUser(String basicAuthUser) {
            if (this.auth == null || !(this.auth instanceof BasicAuthConfiguration)) {
                this.auth = BasicAuthConfiguration.builder().build();
            }
            this.auth = ((BasicAuthConfiguration.BasicAuthConfigurationBuilder)((BasicAuthConfiguration)this.auth).toBuilder().username(Property.ofValue(basicAuthUser))).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder basicAuthPassword(String basicAuthPassword) {
            if (this.auth == null || !(this.auth instanceof BasicAuthConfiguration)) {
                this.auth = BasicAuthConfiguration.builder().build();
            }
            this.auth = ((BasicAuthConfiguration.BasicAuthConfigurationBuilder)((BasicAuthConfiguration)this.auth).toBuilder().password(Property.ofValue(basicAuthPassword))).build();
            return this;
        }

        @Deprecated
        public HttpConfigurationBuilder logLevel(LogLevel logLevel) {
            if (logLevel == LogLevel.TRACE) {
                this.logs = new LoggingType[]{LoggingType.REQUEST_HEADERS, LoggingType.REQUEST_BODY, LoggingType.RESPONSE_HEADERS, LoggingType.RESPONSE_BODY};
            } else if (logLevel == LogLevel.DEBUG) {
                this.logs = new LoggingType[]{LoggingType.REQUEST_HEADERS, LoggingType.RESPONSE_HEADERS};
            } else if (logLevel == LogLevel.INFO) {
                this.logs = new LoggingType[]{LoggingType.RESPONSE_HEADERS};
            }
            return this;
        }

        @Generated
        HttpConfigurationBuilder() {
        }

        @Generated
        public HttpConfigurationBuilder timeout(TimeoutConfiguration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder proxy(ProxyConfiguration proxy) {
            this.proxy = proxy;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder auth(AbstractAuthConfiguration auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder ssl(SslOptions ssl) {
            this.ssl = ssl;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder followRedirects(Property<Boolean> followRedirects) {
            this.followRedirects$value = followRedirects;
            this.followRedirects$set = true;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder allowFailed(Property<Boolean> allowFailed) {
            this.allowFailed$value = allowFailed;
            this.allowFailed$set = true;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder allowedResponseCodes(Property<List<Integer>> allowedResponseCodes) {
            this.allowedResponseCodes = allowedResponseCodes;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder defaultCharset(Property<Charset> defaultCharset) {
            this.defaultCharset$value = defaultCharset;
            this.defaultCharset$set = true;
            return this;
        }

        @Generated
        public HttpConfigurationBuilder logs(LoggingType[] logs) {
            this.logs = logs;
            return this;
        }

        @Deprecated
        @Generated
        public HttpConfigurationBuilder readIdleTimeout(Duration readIdleTimeout) {
            this.readIdleTimeout = readIdleTimeout;
            return this;
        }

        @Deprecated
        @Generated
        public HttpConfigurationBuilder connectionPoolIdleTimeout(Duration connectionPoolIdleTimeout) {
            this.connectionPoolIdleTimeout = connectionPoolIdleTimeout;
            return this;
        }

        @Deprecated
        @Generated
        public HttpConfigurationBuilder maxContentLength(Integer maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        @Generated
        public HttpConfiguration build() {
            Property<Boolean> followRedirects$value = this.followRedirects$value;
            if (!this.followRedirects$set) {
                followRedirects$value = HttpConfiguration.$default$followRedirects();
            }
            Property<Boolean> allowFailed$value = this.allowFailed$value;
            if (!this.allowFailed$set) {
                allowFailed$value = HttpConfiguration.$default$allowFailed();
            }
            Property<Charset> defaultCharset$value = this.defaultCharset$value;
            if (!this.defaultCharset$set) {
                defaultCharset$value = HttpConfiguration.$default$defaultCharset();
            }
            return new HttpConfiguration(this.timeout, this.proxy, this.auth, this.ssl, followRedirects$value, allowFailed$value, this.allowedResponseCodes, defaultCharset$value, this.logs, this.connectTimeout, this.readTimeout, this.proxyType, this.proxyAddress, this.proxyPort, this.proxyUsername, this.proxyPassword, this.basicAuthUser, this.basicAuthPassword, this.logLevel, this.readIdleTimeout, this.connectionPoolIdleTimeout, this.maxContentLength);
        }

        @Generated
        public String toString() {
            return "HttpConfiguration.HttpConfigurationBuilder(timeout=" + String.valueOf(this.timeout) + ", proxy=" + String.valueOf(this.proxy) + ", auth=" + String.valueOf(this.auth) + ", ssl=" + String.valueOf(this.ssl) + ", followRedirects$value=" + String.valueOf(this.followRedirects$value) + ", allowFailed$value=" + String.valueOf(this.allowFailed$value) + ", allowedResponseCodes=" + String.valueOf(this.allowedResponseCodes) + ", defaultCharset$value=" + String.valueOf(this.defaultCharset$value) + ", logs=" + Arrays.deepToString((Object[])this.logs) + ", connectTimeout=" + String.valueOf(this.connectTimeout) + ", readTimeout=" + String.valueOf(this.readTimeout) + ", proxyType=" + String.valueOf((Object)this.proxyType) + ", proxyAddress=" + this.proxyAddress + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", basicAuthUser=" + this.basicAuthUser + ", basicAuthPassword=" + this.basicAuthPassword + ", logLevel=" + String.valueOf(this.logLevel) + ", readIdleTimeout=" + String.valueOf(this.readIdleTimeout) + ", connectionPoolIdleTimeout=" + String.valueOf(this.connectionPoolIdleTimeout) + ", maxContentLength=" + this.maxContentLength + ")";
        }
    }
}

