/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.metrics;

import io.kestra.core.metrics.MetricConfig;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTrigger;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.search.Search;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricRegistry.class);
    public static final String METRIC_WORKER_JOB_PENDING_COUNT = "worker.job.pending";
    public static final String METRIC_WORKER_JOB_PENDING_COUNT_DESCRIPTION = "The number of jobs (tasks or triggers) pending to be run by the Worker";
    public static final String METRIC_WORKER_JOB_RUNNING_COUNT = "worker.job.running";
    public static final String METRIC_WORKER_JOB_RUNNING_COUNT_DESCRIPTION = "The number of jobs (tasks or triggers) currently running inside the Worker";
    public static final String METRIC_WORKER_JOB_THREAD_COUNT = "worker.job.thread";
    public static final String METRIC_WORKER_JOB_THREAD_COUNT_DESCRIPTION = "The number of worker threads";
    public static final String METRIC_WORKER_RUNNING_COUNT = "worker.running.count";
    public static final String METRIC_WORKER_RUNNING_COUNT_DESCRIPTION = "The number of tasks currently running inside the Worker";
    public static final String METRIC_WORKER_QUEUED_DURATION = "worker.queued.duration";
    public static final String METRIC_WORKER_QUEUED_DURATION_DESCRIPTION = "Task queued duration inside the Worker";
    public static final String METRIC_WORKER_STARTED_COUNT = "worker.started.count";
    public static final String METRIC_WORKER_STARTED_COUNT_DESCRIPTION = "The total number of tasks started by the Worker";
    public static final String METRIC_WORKER_TIMEOUT_COUNT = "worker.timeout.count";
    public static final String METRIC_WORKER_TIMEOUT_COUNT_DESCRIPTION = "The total number of tasks that timeout inside the Worker";
    public static final String METRIC_WORKER_ENDED_COUNT = "worker.ended.count";
    public static final String METRIC_WORKER_ENDED_COUNT_DESCRIPTION = "The total number of tasks ended by the Worker";
    public static final String METRIC_WORKER_ENDED_DURATION = "worker.ended.duration";
    public static final String METRIC_WORKER_ENDED_DURATION_DESCRIPTION = "Task run duration inside the Worker";
    public static final String METRIC_WORKER_TRIGGER_DURATION = "worker.trigger.duration";
    public static final String METRIC_WORKER_TRIGGER_DURATION_DESCRIPTION = "Trigger evaluation duration inside the Worker";
    public static final String METRIC_WORKER_TRIGGER_RUNNING_COUNT = "worker.trigger.running.count";
    public static final String METRIC_WORKER_TRIGGER_RUNNING_COUNT_DESCRIPTION = "The number of triggers currently evaluating inside the Worker";
    public static final String METRIC_WORKER_TRIGGER_STARTED_COUNT = "worker.trigger.started.count";
    public static final String METRIC_WORKER_TRIGGER_STARTED_COUNT_DESCRIPTION = "The total number of trigger evaluations started by the Worker";
    public static final String METRIC_WORKER_TRIGGER_ENDED_COUNT = "worker.trigger.ended.count";
    public static final String METRIC_WORKER_TRIGGER_ENDED_COUNT_DESCRIPTION = "The total number of trigger evaluations ended by the Worker";
    public static final String METRIC_WORKER_TRIGGER_ERROR_COUNT = "worker.trigger.error.count";
    public static final String METRIC_WORKER_TRIGGER_ERROR_COUNT_DESCRIPTION = "The total number of trigger evaluations that failed inside the Worker";
    public static final String METRIC_WORKER_TRIGGER_EXECUTION_COUNT = "worker.trigger.execution.count";
    public static final String METRIC_WORKER_TRIGGER_EXECUTION_COUNT_DESCRIPTION = "The total number of triggers evaluated by the Worker";
    public static final String METRIC_WORKER_KILLED_COUNT = "worker.killed.count";
    public static final String METRIC_WORKER_KILLED_COUNT_DESCRIPTION = "The total number of executions killed events received the Executor";
    public static final String METRIC_EXECUTOR_THREAD_COUNT = "executor.thread.count";
    public static final String METRIC_EXECUTOR_THREAD_COUNT_DESCRIPTION = "The number of executor threads";
    public static final String METRIC_EXECUTOR_TASKRUN_CREATED_COUNT = "executor.taskrun.created.count";
    public static final String METRIC_EXECUTOR_TASKRUN_CREATED_COUNT_DESCRIPTION = "The total number of tasks created by the Executor";
    public static final String METRIC_EXECUTOR_TASKRUN_ENDED_COUNT = "executor.taskrun.ended.count";
    public static final String METRIC_EXECUTOR_TASKRUN_ENDED_COUNT_DESCRIPTION = "The total number of tasks ended by the Executor";
    public static final String METRIC_EXECUTOR_TASKRUN_ENDED_DURATION = "executor.taskrun.ended.duration";
    public static final String METRIC_EXECUTOR_TASKRUN_ENDED_DURATION_DESCRIPTION = "Task duration inside the Executor";
    public static final String METRIC_EXECUTOR_FLOWABLE_EXECUTION_COUNT = "executor.flowable.execution.count";
    public static final String METRIC_EXECUTOR_FLOWABLE_EXECUTION_COUNT_DESCRIPTION = "The total number of flowable tasks executed by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_STARTED_COUNT = "executor.execution.started.count";
    public static final String METRIC_EXECUTOR_EXECUTION_STARTED_COUNT_DESCRIPTION = "The total number of executions started by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_END_COUNT = "executor.execution.end.count";
    public static final String METRIC_EXECUTOR_EXECUTION_END_COUNT_DESCRIPTION = "The total number of executions ended by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_DURATION = "executor.execution.duration";
    public static final String METRIC_EXECUTOR_EXECUTION_DURATION_DESCRIPTION = "Execution duration inside the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_MESSAGE_PROCESS_DURATION = "executor.execution.message.process";
    public static final String METRIC_EXECUTOR_EXECUTION_MESSAGE_PROCESS_DURATION_DESCRIPTION = "Duration of a single execution message processed by the Executor";
    public static final String METRIC_EXECUTOR_KILLED_COUNT = "executor.killed.count";
    public static final String METRIC_EXECUTOR_KILLED_COUNT_DESCRIPTION = "The total number of executions killed events received the Executor";
    public static final String METRIC_EXECUTOR_SLA_EXPIRED_COUNT = "executor.sla.expired.count";
    public static final String METRIC_EXECUTOR_SLA_EXPIRED_COUNT_DESCRIPTION = "The total number of expired SLA (i.e. executions with SLA of type MAX_DURATION that took longer than the SLA) evaluated by the Executor";
    public static final String METRIC_EXECUTOR_SLA_VIOLATION_COUNT = "executor.sla.violation.count";
    public static final String METRIC_EXECUTOR_SLA_VIOLATION_COUNT_DESCRIPTION = "The total number of expired SLA (i.e. executions with SLA of type MAX_DURATION that took longer than the SLA) evaluated by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_DELAY_CREATED_COUNT = "executor.execution.delay.created.count";
    public static final String METRIC_EXECUTOR_EXECUTION_DELAY_CREATED_COUNT_DESCRIPTION = "The total number of execution delays created by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_DELAY_ENDED_COUNT = "executor.execution.delay.ended.count";
    public static final String METRIC_EXECUTOR_EXECUTION_DELAY_ENDED_COUNT_DESCRIPTION = "The total number of execution delays ended (resumed) by the Executor";
    public static final String METRIC_EXECUTOR_WORKER_JOB_RESUBMIT_COUNT = "executor.worker.job.resubmit.count";
    public static final String METRIC_EXECUTOR_WORKER_JOB_RESUBMIT_COUNT_DESCRIPTION = "The total number of worker jobs resubmitted to the Worker by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_QUEUED_COUNT = "executor.execution.queued.count";
    public static final String METRIC_EXECUTOR_EXECUTION_QUEUED_COUNT_DESCRIPTION = "The total number of executions queued by the Executor";
    public static final String METRIC_EXECUTOR_EXECUTION_POPPED_COUNT = "executor.execution.popped.count";
    public static final String METRIC_EXECUTOR_EXECUTION_POPPED_COUNT_DESCRIPTION = "The total number of executions popped by the Executor";
    public static final String METRIC_INDEXER_REQUEST_COUNT = "indexer.request.count";
    public static final String METRIC_INDEXER_REQUEST_COUNT_DESCRIPTION = "Total number of batches of records received by the Indexer";
    public static final String METRIC_INDEXER_REQUEST_DURATION = "indexer.request.duration";
    public static final String METRIC_INDEXER_REQUEST_DURATION_DESCRIPTION = "Batch of records duration inside the Indexer";
    public static final String METRIC_INDEXER_REQUEST_RETRY_COUNT = "indexer.request.retry.count";
    public static final String METRIC_INDEXER_REQUEST_RETRY_COUNT_DESCRIPTION = "Total number of batches of records retried by the Indexer";
    public static final String METRIC_INDEXER_SERVER_DURATION = "indexer.server.duration";
    public static final String METRIC_INDEXER_SERVER_DURATION_DESCRIPTION = "Batch of records indexation duration";
    public static final String METRIC_INDEXER_MESSAGE_FAILED_COUNT = "indexer.message.failed.count";
    public static final String METRIC_INDEXER_MESSAGE_FAILED_COUNT_DESCRIPTION = "Total number of records which failed to be indexed by the Indexer";
    public static final String METRIC_INDEXER_MESSAGE_IN_COUNT = "indexer.message.in.count";
    public static final String METRIC_INDEXER_MESSAGE_IN_COUNT_DESCRIPTION = "Total number of records received by the Indexer";
    public static final String METRIC_INDEXER_MESSAGE_OUT_COUNT = "indexer.message.out.count";
    public static final String METRIC_INDEXER_MESSAGE_OUT_COUNT_DESCRIPTION = "Total number of records indexed by the Indexer";
    public static final String METRIC_SCHEDULER_LOOP_COUNT = "scheduler.loop.count";
    public static final String METRIC_SCHEDULER_LOOP_COUNT_DESCRIPTION = "Total number of evaluation loops executed by the Scheduler";
    public static final String METRIC_SCHEDULER_TRIGGER_EVALUATION_DURATION = "scheduler.trigger.evaluation.duration";
    public static final String METRIC_SCHEDULER_TRIGGER_EVALUATION_DURATION_DESCRIPTION = "Trigger evaluation duration for trigger executed inside the Scheduler (Schedulable triggers)";
    public static final String METRIC_SCHEDULER_TRIGGER_COUNT = "scheduler.trigger.count";
    public static final String METRIC_SCHEDULER_TRIGGER_COUNT_DESCRIPTION = "Total number of executions triggered by the Scheduler";
    public static final String METRIC_SCHEDULER_TRIGGER_DELAY_DURATION = "scheduler.trigger.delay.duration";
    public static final String METRIC_SCHEDULER_TRIGGER_DELAY_DURATION_DESCRIPTION = "Trigger delay duration inside the Scheduler";
    public static final String METRIC_SCHEDULER_EVALUATE_COUNT = "scheduler.evaluate.count";
    public static final String METRIC_SCHEDULER_EVALUATE_COUNT_DESCRIPTION = "Total number of triggers evaluated by the Scheduler";
    public static final String METRIC_SCHEDULER_EXECUTION_LOCK_DURATION = "scheduler.execution.lock.duration";
    public static final String METRIC_SCHEDULER_EXECUTION_LOCK_DURATION_DESCRIPTION = "Trigger lock duration waiting for an execution to be terminated";
    public static final String METRIC_SCHEDULER_EXECUTION_MISSING_DURATION = "scheduler.execution.missing.duration";
    public static final String METRIC_SCHEDULER_EXECUTION_MISSING_DURATION_DESCRIPTION = "Missing execution duration inside the Scheduler. A missing execution is an execution that was triggered by the Scheduler but not yet started by the Executor";
    public static final String METRIC_SCHEDULER_EVALUATION_LOOP_DURATION = "scheduler.evaluation.loop.duration";
    public static final String METRIC_SCHEDULER_EVALUATION_LOOP_DURATION_DESCRIPTION = "Trigger evaluation loop duration inside the Scheduler";
    public static final String METRIC_STREAMS_STATE_COUNT = "stream.state.count";
    public static final String METRIC_STREAMS_STATE_COUNT_DESCRIPTION = "Number of Kafka Stream applications by state";
    public static final String METRIC_JDBC_QUERY_DURATION = "jdbc.query.duration";
    public static final String METRIC_JDBC_QUERY_DURATION_DESCRIPTION = "Duration of database queries";
    public static final String METRIC_QUEUE_BIG_MESSAGE_COUNT = "queue.big_message.count";
    public static final String METRIC_QUEUE_BIG_MESSAGE_COUNT_DESCRIPTION = "Total number of big messages";
    public static final String METRIC_QUEUE_PRODUCE_COUNT = "queue.produce.count";
    public static final String METRIC_QUEUE_PRODUCE_COUNT_DESCRIPTION = "Total number of produced messages";
    public static final String METRIC_QUEUE_RECEIVE_DURATION = "queue.receive.duration";
    public static final String METRIC_QUEUE_RECEIVE_DURATION_DESCRIPTION = "Queue duration to receive and consume a batch of messages";
    public static final String METRIC_QUEUE_POLL_SIZE = "queue.poll.size";
    public static final String METRIC_QUEUE_POLL_SIZE_DESCRIPTION = "Size of a poll to the queue (message batch size)";
    public static final String TAG_TASK_TYPE = "task_type";
    public static final String TAG_TRIGGER_TYPE = "trigger_type";
    public static final String TAG_FLOW_ID = "flow_id";
    public static final String TAG_NAMESPACE_ID = "namespace_id";
    public static final String TAG_STATE = "state";
    public static final String TAG_ATTEMPT_COUNT = "attempt_count";
    public static final String TAG_WORKER_GROUP = "worker_group";
    public static final String TAG_TENANT_ID = "tenant_id";
    public static final String TAG_CLASS_NAME = "class_name";
    public static final String TAG_EXECUTION_KILLED_TYPE = "execution_killed_type";
    public static final String TAG_QUEUE_CONSUMER = "consumer";
    public static final String TAG_QUEUE_CONSUMER_GROUP = "consumer_group";
    public static final String TAG_QUEUE_TYPE = "queue_type";
    @Inject
    private MeterRegistry meterRegistry;
    @Inject
    private MetricConfig metricConfig;

    public Counter counter(String name, String description, String ... tags) {
        return Counter.builder((String)this.metricName(name)).description(description).tags(tags).register(this.meterRegistry);
    }

    public <T extends Number> T gauge(String name, String description, T number, String ... tags) {
        Gauge.builder((String)this.metricName(name), () -> number).description(description).tags(tags).register(this.meterRegistry);
        return number;
    }

    public Timer timer(String name, String description, String ... tags) {
        return Timer.builder((String)this.metricName(name)).description(description).tags(tags).register(this.meterRegistry);
    }

    public DistributionSummary summary(String name, String description, String ... tags) {
        return DistributionSummary.builder((String)this.metricName(name)).description(description).tags(tags).register(this.meterRegistry);
    }

    public Search find(String name) {
        return this.meterRegistry.find(this.metricName(name));
    }

    public Counter findCounter(String name) {
        return this.meterRegistry.find(this.metricName(name)).counter();
    }

    public Gauge findGauge(String name) {
        return this.meterRegistry.find(this.metricName(name)).gauge();
    }

    public Timer findTimer(String name) {
        return this.meterRegistry.find(this.metricName(name)).timer();
    }

    public DistributionSummary findDistributionSummary(String name) {
        return this.meterRegistry.find(this.metricName(name)).summary();
    }

    private String metricName(String name) {
        return (String)(this.metricConfig.getPrefix() != null ? this.metricConfig.getPrefix() + "." : "") + name;
    }

    public String[] tags(WorkerTask workerTask, String workerGroup, String ... tags) {
        Object[] baseTags = (String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.addAll((Object[])this.tags(workerTask.getTask()), (Object[])tags)), (Object[])new String[]{TAG_NAMESPACE_ID, workerTask.getTaskRun().getNamespace(), TAG_FLOW_ID, workerTask.getTaskRun().getFlowId()});
        baseTags = workerGroup == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_WORKER_GROUP, workerGroup});
        return workerTask.getTaskRun().getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, workerTask.getTaskRun().getTenantId()});
    }

    public String[] tags(WorkerTrigger workerTrigger, String workerGroup, String ... tags) {
        Object[] baseTags = (String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.addAll((Object[])this.tags(workerTrigger.getTrigger()), (Object[])tags)), (Object[])new String[]{TAG_NAMESPACE_ID, workerTrigger.getTriggerContext().getNamespace(), TAG_FLOW_ID, workerTrigger.getTriggerContext().getFlowId()});
        baseTags = workerGroup == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_WORKER_GROUP, workerGroup});
        return workerTrigger.getTriggerContext().getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, workerTrigger.getTriggerContext().getTenantId()});
    }

    public String[] tags(WorkerTaskResult workerTaskResult, String ... tags) {
        Object[] baseTags = (String[])ArrayUtils.addAll((Object[])tags, (Object[])new String[]{TAG_NAMESPACE_ID, workerTaskResult.getTaskRun().getNamespace(), TAG_FLOW_ID, workerTaskResult.getTaskRun().getFlowId(), TAG_STATE, workerTaskResult.getTaskRun().getState().getCurrent().name()});
        return workerTaskResult.getTaskRun().getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, workerTaskResult.getTaskRun().getTenantId()});
    }

    public String[] tags(SubflowExecutionResult subflowExecutionResult, String ... tags) {
        Object[] baseTags = (String[])ArrayUtils.addAll((Object[])tags, (Object[])new String[]{TAG_NAMESPACE_ID, subflowExecutionResult.getParentTaskRun().getNamespace(), TAG_FLOW_ID, subflowExecutionResult.getParentTaskRun().getFlowId(), TAG_STATE, subflowExecutionResult.getParentTaskRun().getState().getCurrent().name()});
        return subflowExecutionResult.getParentTaskRun().getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, subflowExecutionResult.getParentTaskRun().getTenantId()});
    }

    public String[] tags(Task task) {
        return new String[]{TAG_TASK_TYPE, task.getType()};
    }

    public String[] tags(AbstractTrigger trigger) {
        return new String[]{TAG_TRIGGER_TYPE, trigger.getType()};
    }

    public String[] tags(Execution execution) {
        Object[] baseTags = new String[]{TAG_FLOW_ID, execution.getFlowId(), TAG_NAMESPACE_ID, execution.getNamespace(), TAG_STATE, execution.getState().getCurrent().name()};
        return execution.getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, execution.getTenantId()});
    }

    public String[] tags(TriggerContext triggerContext) {
        Object[] baseTags = new String[]{TAG_FLOW_ID, triggerContext.getFlowId(), TAG_NAMESPACE_ID, triggerContext.getNamespace()};
        return triggerContext.getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, triggerContext.getTenantId()});
    }

    public String[] tags(ExecutionKilled executionKilled) {
        Object[] baseTags = new String[]{TAG_EXECUTION_KILLED_TYPE, executionKilled.getType()};
        return executionKilled.getTenantId() == null ? baseTags : (String[])ArrayUtils.addAll((Object[])baseTags, (Object[])new String[]{TAG_TENANT_ID, executionKilled.getTenantId()});
    }

    public Tags tags(String ... tags) {
        return Tags.of((String[])tags);
    }

    public void bind(MeterBinder meterBinder) {
        try {
            meterBinder.bindTo(this.meterRegistry);
        }
        catch (Exception e) {
            log.warn("Error on metrics", (Throwable)e);
        }
    }
}

