/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.micronaut.core.annotation.Introspected;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=ExecutionUsageBuilderImpl.class)
public class ExecutionUsage {
    private final List<DailyExecutionStatistics> dailyExecutionsCount;

    public static ExecutionUsage of(String tenantId, ExecutionRepositoryInterface executionRepository, ZonedDateTime from, ZonedDateTime to) {
        return ((ExecutionUsageBuilder)ExecutionUsage.builder().dailyExecutionsCount(executionRepository.dailyStatistics(null, tenantId, null, null, null, from, to, DateUtils.GroupType.DAY, null))).build();
    }

    public static ExecutionUsage of(ExecutionRepositoryInterface repository, ZonedDateTime from, ZonedDateTime to) {
        return ((ExecutionUsageBuilder)ExecutionUsage.builder().dailyExecutionsCount(repository.dailyStatisticsForAllTenants(null, null, null, from, to, DateUtils.GroupType.DAY))).build();
    }

    @Generated
    protected ExecutionUsage(ExecutionUsageBuilder<?, ?> b) {
        this.dailyExecutionsCount = b.dailyExecutionsCount;
    }

    @Generated
    public static ExecutionUsageBuilder<?, ?> builder() {
        return new ExecutionUsageBuilderImpl();
    }

    @Generated
    public List<DailyExecutionStatistics> getDailyExecutionsCount() {
        return this.dailyExecutionsCount;
    }

    @Generated
    public static abstract class ExecutionUsageBuilder<C extends ExecutionUsage, B extends ExecutionUsageBuilder<C, B>> {
        @Generated
        private List<DailyExecutionStatistics> dailyExecutionsCount;

        @Generated
        public B dailyExecutionsCount(List<DailyExecutionStatistics> dailyExecutionsCount) {
            this.dailyExecutionsCount = dailyExecutionsCount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ExecutionUsage.ExecutionUsageBuilder(dailyExecutionsCount=" + String.valueOf(this.dailyExecutionsCount) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ExecutionUsageBuilderImpl
    extends ExecutionUsageBuilder<ExecutionUsage, ExecutionUsageBuilderImpl> {
        @Generated
        private ExecutionUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionUsage build() {
            return new ExecutionUsage(this);
        }
    }
}

