/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.dashboards;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.dashboards.TimeWindow;
import io.kestra.core.models.dashboards.charts.Chart;
import io.kestra.core.utils.IdUtils;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Introspected
public class Dashboard
implements HasUID,
DeletedInterface {
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @Hidden
    @NotNull
    @NotBlank
    private String id;
    @NotNull
    @NotBlank
    private String title;
    private String description;
    @Valid
    private TimeWindow timeWindow;
    @Valid
    private List<Chart<?>> charts;
    @Hidden
    @NotNull
    private boolean deleted;
    @Hidden
    private Instant created;
    @Hidden
    private Instant updated;
    private String sourceCode;

    @Override
    @JsonIgnore
    public String uid() {
        return IdUtils.fromParts(this.tenantId, this.id);
    }

    public Dashboard toDeleted() {
        return ((DashboardBuilder)this.toBuilder().deleted(true)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dashboard dashboard = (Dashboard)o;
        return this.deleted == dashboard.deleted && Objects.equals(this.tenantId, dashboard.tenantId) && Objects.equals(this.id, dashboard.id) && Objects.equals(this.title, dashboard.title) && Objects.equals(this.description, dashboard.description) && Objects.equals(this.timeWindow, dashboard.timeWindow) && Objects.equals(this.charts, dashboard.charts) && Objects.equals(this.sourceCode, dashboard.sourceCode);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.id, this.title, this.description, this.timeWindow, this.charts, this.deleted, this.sourceCode);
    }

    @Generated
    private static TimeWindow $default$timeWindow() {
        return TimeWindow.builder().build();
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    protected Dashboard(DashboardBuilder<?, ?> b) {
        this.tenantId = b.tenantId;
        this.id = b.id;
        this.title = b.title;
        this.description = b.description;
        this.timeWindow = b.timeWindow$set ? b.timeWindow$value : Dashboard.$default$timeWindow();
        this.charts = b.charts;
        this.deleted = b.deleted$set ? b.deleted$value : Dashboard.$default$deleted();
        this.created = b.created;
        this.updated = b.updated;
        this.sourceCode = b.sourceCode;
    }

    @Generated
    public static DashboardBuilder<?, ?> builder() {
        return new DashboardBuilderImpl();
    }

    @Generated
    public DashboardBuilder<?, ?> toBuilder() {
        return new DashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    @Generated
    public List<Chart<?>> getCharts() {
        return this.charts;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @Generated
    public String getSourceCode() {
        return this.sourceCode;
    }

    @Generated
    public Dashboard() {
        this.timeWindow = Dashboard.$default$timeWindow();
        this.deleted = Dashboard.$default$deleted();
    }

    @Generated
    public String toString() {
        return "Dashboard(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", timeWindow=" + String.valueOf(this.getTimeWindow()) + ", charts=" + String.valueOf(this.getCharts()) + ", deleted=" + this.isDeleted() + ", created=" + String.valueOf(this.getCreated()) + ", updated=" + String.valueOf(this.getUpdated()) + ", sourceCode=" + this.getSourceCode() + ")";
    }

    @Generated
    public static abstract class DashboardBuilder<C extends Dashboard, B extends DashboardBuilder<C, B>> {
        @Generated
        private String tenantId;
        @Generated
        private String id;
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private boolean timeWindow$set;
        @Generated
        private TimeWindow timeWindow$value;
        @Generated
        private List<Chart<?>> charts;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private Instant created;
        @Generated
        private Instant updated;
        @Generated
        private String sourceCode;

        @Generated
        protected B $fillValuesFrom(C instance) {
            DashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Dashboard instance, DashboardBuilder<?, ?> b) {
            b.tenantId(instance.tenantId);
            b.id(instance.id);
            b.title(instance.title);
            b.description(instance.description);
            b.timeWindow(instance.timeWindow);
            b.charts(instance.charts);
            b.deleted(instance.deleted);
            b.created(instance.created);
            b.updated(instance.updated);
            b.sourceCode(instance.sourceCode);
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B timeWindow(TimeWindow timeWindow) {
            this.timeWindow$value = timeWindow;
            this.timeWindow$set = true;
            return this.self();
        }

        @Generated
        public B charts(List<Chart<?>> charts) {
            this.charts = charts;
            return this.self();
        }

        @Generated
        public B deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        public B created(Instant created) {
            this.created = created;
            return this.self();
        }

        @Generated
        public B updated(Instant updated) {
            this.updated = updated;
            return this.self();
        }

        @Generated
        public B sourceCode(String sourceCode) {
            this.sourceCode = sourceCode;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Dashboard.DashboardBuilder(tenantId=" + this.tenantId + ", id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", timeWindow$value=" + String.valueOf(this.timeWindow$value) + ", charts=" + String.valueOf(this.charts) + ", deleted$value=" + this.deleted$value + ", created=" + String.valueOf(this.created) + ", updated=" + String.valueOf(this.updated) + ", sourceCode=" + this.sourceCode + ")";
        }
    }

    @Generated
    private static final class DashboardBuilderImpl
    extends DashboardBuilder<Dashboard, DashboardBuilderImpl> {
        @Generated
        private DashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected DashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Dashboard build() {
            return new Dashboard(this);
        }
    }
}

