/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.dashboards.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.EndsWith;
import io.kestra.core.models.dashboards.filters.EqualTo;
import io.kestra.core.models.dashboards.filters.GreaterThan;
import io.kestra.core.models.dashboards.filters.GreaterThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.In;
import io.kestra.core.models.dashboards.filters.IsFalse;
import io.kestra.core.models.dashboards.filters.IsNotNull;
import io.kestra.core.models.dashboards.filters.IsNull;
import io.kestra.core.models.dashboards.filters.IsTrue;
import io.kestra.core.models.dashboards.filters.LessThan;
import io.kestra.core.models.dashboards.filters.LessThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.NotEqualTo;
import io.kestra.core.models.dashboards.filters.NotIn;
import io.kestra.core.models.dashboards.filters.Or;
import io.kestra.core.models.dashboards.filters.Regex;
import io.kestra.core.models.dashboards.filters.StartsWith;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Contains.class, name="CONTAINS"), @JsonSubTypes.Type(value=EndsWith.class, name="ENDS_WITH"), @JsonSubTypes.Type(value=EqualTo.class, name="EQUAL_TO"), @JsonSubTypes.Type(value=GreaterThan.class, name="GREATER_THAN"), @JsonSubTypes.Type(value=GreaterThanOrEqualTo.class, name="GREATER_THAN_OR_EQUAL_TO"), @JsonSubTypes.Type(value=In.class, name="IN"), @JsonSubTypes.Type(value=IsFalse.class, name="IS_FALSE"), @JsonSubTypes.Type(value=IsNotNull.class, name="IS_NOT_NULL"), @JsonSubTypes.Type(value=IsNull.class, name="IS_NULL"), @JsonSubTypes.Type(value=IsTrue.class, name="IS_TRUE"), @JsonSubTypes.Type(value=LessThan.class, name="LESS_THAN"), @JsonSubTypes.Type(value=LessThanOrEqualTo.class, name="LESS_THAN_OR_EQUAL_TO"), @JsonSubTypes.Type(value=NotEqualTo.class, name="NOT_EQUAL_TO"), @JsonSubTypes.Type(value=NotIn.class, name="NOT_IN"), @JsonSubTypes.Type(value=Or.class, name="OR"), @JsonSubTypes.Type(value=Regex.class, name="REGEX"), @JsonSubTypes.Type(value=StartsWith.class, name="STARTS_WITH")})
@Introspected
public abstract class AbstractFilter<F extends Enum<F>> {
    @NotNull
    @JsonProperty(value="field", required=true)
    @Valid
    private F field;
    private String labelKey;

    public abstract FilterType getType();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractFilter) {
            AbstractFilter filter = (AbstractFilter)o;
            return filter.getType().equals((Object)this.getType());
        }
        return false;
    }

    @Generated
    protected AbstractFilter(AbstractFilterBuilder<F, ?, ?> b) {
        this.field = b.field;
        this.labelKey = b.labelKey;
    }

    @Generated
    public F getField() {
        return this.field;
    }

    @Generated
    public String getLabelKey() {
        return this.labelKey;
    }

    @Generated
    public AbstractFilter() {
    }

    public static enum FilterType {
        CONTAINS,
        ENDS_WITH,
        EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO,
        IN,
        IS_FALSE,
        IS_NOT_NULL,
        IS_NULL,
        IS_TRUE,
        LESS_THAN,
        LESS_THAN_OR_EQUAL_TO,
        NOT_EQUAL_TO,
        NOT_IN,
        OR,
        REGEX,
        STARTS_WITH;

    }

    @Generated
    public static abstract class AbstractFilterBuilder<F extends Enum<F>, C extends AbstractFilter<F>, B extends AbstractFilterBuilder<F, C, B>> {
        @Generated
        private F field;
        @Generated
        private String labelKey;

        @JsonProperty(value="field", required=true)
        @Generated
        public B field(F field) {
            this.field = field;
            return this.self();
        }

        @Generated
        public B labelKey(String labelKey) {
            this.labelKey = labelKey;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractFilter.AbstractFilterBuilder(field=" + String.valueOf(this.field) + ", labelKey=" + this.labelKey + ")";
        }
    }
}

