/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.event.Level;

public final class LogEntry
implements DeletedInterface,
TenantInterface {
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @Nullable
    private final String taskId;
    @Nullable
    private final String executionId;
    @Nullable
    private final String taskRunId;
    @Nullable
    @JsonInclude
    private final Integer attemptNumber;
    @Nullable
    private final String triggerId;
    private final Instant timestamp;
    private final Level level;
    private final String thread;
    private final String message;
    @NotNull
    private final boolean deleted;
    @Nullable
    private final ExecutionKind executionKind;

    public static List<Level> findLevelsByMin(Level minLevel) {
        if (minLevel == null) {
            return Arrays.asList(Level.values());
        }
        return Arrays.stream(Level.values()).filter(level -> level.toInt() >= minLevel.toInt()).toList();
    }

    public static LogEntry of(Execution execution) {
        return LogEntry.builder().tenantId(execution.getTenantId()).namespace(execution.getNamespace()).flowId(execution.getFlowId()).executionId(execution.getId()).executionKind(execution.getKind()).build();
    }

    public static LogEntry of(TaskRun taskRun, ExecutionKind executionKind) {
        return LogEntry.builder().tenantId(taskRun.getTenantId()).namespace(taskRun.getNamespace()).flowId(taskRun.getFlowId()).taskId(taskRun.getTaskId()).executionId(taskRun.getExecutionId()).taskRunId(taskRun.getId()).attemptNumber(taskRun.attemptNumber()).executionKind(executionKind).build();
    }

    public static LogEntry of(Flow flow, AbstractTrigger abstractTrigger, ExecutionKind executionKind) {
        return LogEntry.builder().tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).triggerId(abstractTrigger.getId()).executionId(abstractTrigger.getId()).build();
    }

    public static LogEntry of(TriggerContext triggerContext, AbstractTrigger abstractTrigger, ExecutionKind executionKind) {
        return LogEntry.builder().tenantId(triggerContext.getTenantId()).namespace(triggerContext.getNamespace()).flowId(triggerContext.getFlowId()).triggerId(abstractTrigger.getId()).executionId(abstractTrigger.getId()).build();
    }

    public static String toPrettyString(LogEntry logEntry) {
        return logEntry.getTimestamp().toString() + " " + String.valueOf(logEntry.getLevel()) + " " + logEntry.getMessage();
    }

    public static String toPrettyString(LogEntry logEntry, Integer maxMessageSize) {
        String message = maxMessageSize != null && maxMessageSize > 0 ? StringUtils.truncate((String)logEntry.getMessage(), (int)maxMessageSize) : logEntry.getMessage();
        return logEntry.getTimestamp().toString() + " " + String.valueOf(logEntry.getLevel()) + " " + message;
    }

    public Map<String, String> toMap() {
        return Stream.of(new AbstractMap.SimpleEntry<String, String>("tenantId", this.tenantId), new AbstractMap.SimpleEntry<String, String>("namespace", this.namespace), new AbstractMap.SimpleEntry<String, String>("flowId", this.flowId), new AbstractMap.SimpleEntry<String, String>("taskId", this.taskId), new AbstractMap.SimpleEntry<String, String>("executionId", this.executionId), new AbstractMap.SimpleEntry<String, String>("taskRunId", this.taskRunId), new AbstractMap.SimpleEntry<String, String>("triggerId", this.triggerId), new AbstractMap.SimpleEntry<String, String>("executionKind", Optional.ofNullable(this.executionKind).map(executionKind -> executionKind.name()).orElse(null))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Object> toLogMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.toMap());
        map.put("attemptNumber", (String)((Object)this.attemptNumber));
        map.put("thread", this.thread);
        map.put("message", this.message);
        return map;
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @ConstructorProperties(value={"tenantId", "namespace", "flowId", "taskId", "executionId", "taskRunId", "attemptNumber", "triggerId", "timestamp", "level", "thread", "message", "deleted", "executionKind"})
    @Generated
    LogEntry(String tenantId, String namespace, String flowId, @Nullable String taskId, @Nullable String executionId, @Nullable String taskRunId, @Nullable Integer attemptNumber, @Nullable String triggerId, Instant timestamp, Level level, String thread, String message, boolean deleted, @Nullable ExecutionKind executionKind) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.taskId = taskId;
        this.executionId = executionId;
        this.taskRunId = taskRunId;
        this.attemptNumber = attemptNumber;
        this.triggerId = triggerId;
        this.timestamp = timestamp;
        this.level = level;
        this.thread = thread;
        this.message = message;
        this.deleted = deleted;
        this.executionKind = executionKind;
    }

    @Generated
    public static LogEntryBuilder builder() {
        return new LogEntryBuilder();
    }

    @Generated
    public LogEntryBuilder toBuilder() {
        return new LogEntryBuilder().tenantId(this.tenantId).namespace(this.namespace).flowId(this.flowId).taskId(this.taskId).executionId(this.executionId).taskRunId(this.taskRunId).attemptNumber(this.attemptNumber).triggerId(this.triggerId).timestamp(this.timestamp).level(this.level).thread(this.thread).message(this.message).deleted(this.deleted).executionKind(this.executionKind);
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Nullable
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Nullable
    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Nullable
    @Generated
    public String getTaskRunId() {
        return this.taskRunId;
    }

    @Nullable
    @Generated
    public Integer getAttemptNumber() {
        return this.attemptNumber;
    }

    @Nullable
    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getThread() {
        return this.thread;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Nullable
    @Generated
    public ExecutionKind getExecutionKind() {
        return this.executionKind;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)o;
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$attemptNumber = this.getAttemptNumber();
        Integer other$attemptNumber = other.getAttemptNumber();
        if (this$attemptNumber == null ? other$attemptNumber != null : !((Object)this$attemptNumber).equals(other$attemptNumber)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$taskRunId = this.getTaskRunId();
        String other$taskRunId = other.getTaskRunId();
        if (this$taskRunId == null ? other$taskRunId != null : !this$taskRunId.equals(other$taskRunId)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$thread = this.getThread();
        String other$thread = other.getThread();
        if (this$thread == null ? other$thread != null : !this$thread.equals(other$thread)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ExecutionKind this$executionKind = this.getExecutionKind();
        ExecutionKind other$executionKind = other.getExecutionKind();
        return !(this$executionKind == null ? other$executionKind != null : !((Object)((Object)this$executionKind)).equals((Object)other$executionKind));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $attemptNumber = this.getAttemptNumber();
        result = result * 59 + ($attemptNumber == null ? 43 : ((Object)$attemptNumber).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $taskRunId = this.getTaskRunId();
        result = result * 59 + ($taskRunId == null ? 43 : $taskRunId.hashCode());
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $thread = this.getThread();
        result = result * 59 + ($thread == null ? 43 : $thread.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ExecutionKind $executionKind = this.getExecutionKind();
        result = result * 59 + ($executionKind == null ? 43 : ((Object)((Object)$executionKind)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogEntry(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", taskId=" + this.getTaskId() + ", executionId=" + this.getExecutionId() + ", taskRunId=" + this.getTaskRunId() + ", attemptNumber=" + this.getAttemptNumber() + ", triggerId=" + this.getTriggerId() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", level=" + String.valueOf(this.getLevel()) + ", thread=" + this.getThread() + ", message=" + this.getMessage() + ", deleted=" + this.isDeleted() + ", executionKind=" + String.valueOf((Object)this.getExecutionKind()) + ")";
    }

    @Generated
    public static class LogEntryBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String taskId;
        @Generated
        private String executionId;
        @Generated
        private String taskRunId;
        @Generated
        private Integer attemptNumber;
        @Generated
        private String triggerId;
        @Generated
        private Instant timestamp;
        @Generated
        private Level level;
        @Generated
        private String thread;
        @Generated
        private String message;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private ExecutionKind executionKind;

        @Generated
        LogEntryBuilder() {
        }

        @Generated
        public LogEntryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public LogEntryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public LogEntryBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public LogEntryBuilder taskId(@Nullable String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public LogEntryBuilder executionId(@Nullable String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public LogEntryBuilder taskRunId(@Nullable String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        @Generated
        public LogEntryBuilder attemptNumber(@Nullable Integer attemptNumber) {
            this.attemptNumber = attemptNumber;
            return this;
        }

        @Generated
        public LogEntryBuilder triggerId(@Nullable String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public LogEntryBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public LogEntryBuilder level(Level level) {
            this.level = level;
            return this;
        }

        @Generated
        public LogEntryBuilder thread(String thread) {
            this.thread = thread;
            return this;
        }

        @Generated
        public LogEntryBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public LogEntryBuilder deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this;
        }

        @Generated
        public LogEntryBuilder executionKind(@Nullable ExecutionKind executionKind) {
            this.executionKind = executionKind;
            return this;
        }

        @Generated
        public LogEntry build() {
            boolean deleted$value = this.deleted$value;
            if (!this.deleted$set) {
                deleted$value = LogEntry.$default$deleted();
            }
            return new LogEntry(this.tenantId, this.namespace, this.flowId, this.taskId, this.executionId, this.taskRunId, this.attemptNumber, this.triggerId, this.timestamp, this.level, this.thread, this.message, deleted$value, this.executionKind);
        }

        @Generated
        public String toString() {
            return "LogEntry.LogEntryBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", taskRunId=" + this.taskRunId + ", attemptNumber=" + this.attemptNumber + ", triggerId=" + this.triggerId + ", timestamp=" + String.valueOf(this.timestamp) + ", level=" + String.valueOf(this.level) + ", thread=" + this.thread + ", message=" + this.message + ", deleted$value=" + this.deleted$value + ", executionKind=" + String.valueOf((Object)this.executionKind) + ")";
        }
    }
}

