/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.utils.IdUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TaskRun
implements TenantInterface {
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    String id;
    @NotNull
    String executionId;
    @NotNull
    String namespace;
    @NotNull
    String flowId;
    @NotNull
    String taskId;
    String parentTaskRunId;
    String value;
    List<TaskRunAttempt> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @Nullable
    @Schema(implementation=Object.class)
    Variables outputs;
    @NotNull
    State state;
    Integer iteration;
    Boolean dynamic;
    Boolean forceExecution;

    @Deprecated
    public void setItems(String items) {
    }

    public TaskRun withState(State.Type state) {
        return new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state.withState(state), this.iteration, this.dynamic, this.forceExecution);
    }

    public TaskRun replaceState(State newState) {
        return new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, newState, this.iteration, this.dynamic, this.forceExecution);
    }

    public TaskRun fail() {
        TaskRunAttempt attempt = TaskRunAttempt.builder().state(new State(State.Type.FAILED)).build();
        List<Object> newAttempts = this.attempts == null ? new ArrayList(1) : this.attempts;
        newAttempts.add(attempt);
        return new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, newAttempts, this.outputs, this.state.withState(State.Type.FAILED), this.iteration, this.dynamic, this.forceExecution);
    }

    public TaskRun forChildExecution(Map<String, String> remapTaskRunId, String executionId, State state) {
        return TaskRun.builder().tenantId(this.getTenantId()).id(remapTaskRunId.get(this.getId())).executionId(executionId != null ? executionId : this.getExecutionId()).namespace(this.getNamespace()).flowId(this.getFlowId()).taskId(this.getTaskId()).parentTaskRunId(this.getParentTaskRunId() != null ? remapTaskRunId.get(this.getParentTaskRunId()) : null).value(this.getValue()).attempts(this.getAttempts()).outputs(this.getOutputs()).state(state == null ? this.getState() : state).iteration(this.getIteration()).build();
    }

    public static TaskRun of(Execution execution, ResolvedTask resolvedTask) {
        return TaskRun.builder().tenantId(execution.getTenantId()).id(IdUtils.create()).executionId(execution.getId()).namespace(execution.getNamespace()).flowId(execution.getFlowId()).taskId(resolvedTask.getTask().getId()).parentTaskRunId(resolvedTask.getParentId()).value(resolvedTask.getValue()).iteration(resolvedTask.getIteration()).state(new State()).build();
    }

    public int attemptNumber() {
        if (this.attempts == null) {
            return 0;
        }
        return this.attempts.size();
    }

    public TaskRunAttempt lastAttempt() {
        if (this.attempts == null) {
            return null;
        }
        return this.attempts.stream().reduce((a, b) -> b).orElse(null);
    }

    public TaskRun onRunningResend() {
        TaskRunBuilder taskRunBuilder = this.toBuilder();
        if (taskRunBuilder.attempts == null || taskRunBuilder.attempts.isEmpty()) {
            taskRunBuilder.attempts = new ArrayList<TaskRunAttempt>();
            taskRunBuilder.attempts.add(TaskRunAttempt.builder().state(new State(this.state, State.Type.RESUBMITTED)).build());
        } else {
            ArrayList<TaskRunAttempt> taskRunAttempts = new ArrayList<TaskRunAttempt>(taskRunBuilder.attempts);
            TaskRunAttempt lastAttempt = taskRunAttempts.get(taskRunBuilder.attempts.size() - 1);
            if (!lastAttempt.getState().isTerminated()) {
                taskRunAttempts.set(taskRunBuilder.attempts.size() - 1, lastAttempt.withState(State.Type.RESUBMITTED));
            } else {
                taskRunAttempts.add(TaskRunAttempt.builder().state(new State().withState(State.Type.RESUBMITTED)).build());
            }
            taskRunBuilder.attempts(taskRunAttempts);
        }
        return taskRunBuilder.build();
    }

    public boolean isSame(TaskRun taskRun) {
        return this.getId().equals(taskRun.getId()) && (this.getValue() == null && taskRun.getValue() == null || this.getValue() != null && this.getValue().equals(taskRun.getValue())) && (this.getIteration() == null && taskRun.getIteration() == null || this.getIteration() != null && this.getIteration().equals(taskRun.getIteration()));
    }

    public String toString(boolean pretty) {
        if (!pretty) {
            return super.toString();
        }
        return "TaskRun(id=" + this.getId() + ", taskId=" + this.getTaskId() + ", value=" + this.getValue() + ", parentTaskRunId=" + this.getParentTaskRunId() + ", state=" + this.getState().getCurrent().toString() + ", outputs=" + String.valueOf(this.getOutputs()) + ", attempts=" + String.valueOf(this.getAttempts()) + ")";
    }

    public String toStringState() {
        return "TaskRun(id=" + this.getId() + ", taskId=" + this.getTaskId() + ", value=" + this.getValue() + ", state=" + this.getState().getCurrent().toString() + ")";
    }

    public Instant nextRetryDate(AbstractRetry retry, Execution execution) {
        if (retry.getMaxAttempts() != null && execution.getMetadata().getAttemptNumber() >= retry.getMaxAttempts()) {
            return null;
        }
        Instant base = this.lastAttempt().getState().maxDate();
        Instant nextDate = retry.nextRetryDate(execution.getMetadata().getAttemptNumber(), base);
        if (retry.getMaxDuration() != null && nextDate.isAfter(execution.getMetadata().getOriginalCreatedDate().plus(retry.getMaxDuration()))) {
            return null;
        }
        return nextDate;
    }

    public Instant nextRetryDate(AbstractRetry retry) {
        if (this.attempts == null || this.attempts.isEmpty() || retry.getMaxAttempts() != null && this.attemptNumber() >= retry.getMaxAttempts()) {
            return null;
        }
        Instant base = this.lastAttempt().getState().maxDate();
        Instant nextDate = retry.nextRetryDate(this.attempts.size(), base);
        if (retry.getMaxDuration() != null && nextDate.isAfter(this.attempts.getFirst().getState().minDate().plus(retry.getMaxDuration()))) {
            return null;
        }
        return nextDate;
    }

    public boolean shouldBeRetried(AbstractRetry retry) {
        if (retry == null) {
            return false;
        }
        return this.nextRetryDate(retry) != null;
    }

    public TaskRun incrementIteration() {
        int iteration = this.iteration == null ? 0 : this.iteration;
        return this.toBuilder().iteration(iteration + 1).build();
    }

    public TaskRun resetAttempts() {
        return this.toBuilder().state(new State(State.Type.CREATED, List.of(this.state.getHistories().getFirst()))).attempts(null).build();
    }

    @Generated
    public static TaskRunBuilder builder() {
        return new TaskRunBuilder();
    }

    @Generated
    public TaskRunBuilder toBuilder() {
        return new TaskRunBuilder().tenantId(this.tenantId).id(this.id).executionId(this.executionId).namespace(this.namespace).flowId(this.flowId).taskId(this.taskId).parentTaskRunId(this.parentTaskRunId).value(this.value).attempts(this.attempts).outputs(this.outputs).state(this.state).iteration(this.iteration).dynamic(this.dynamic).forceExecution(this.forceExecution);
    }

    @Generated
    public String toString() {
        return "TaskRun(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", executionId=" + this.getExecutionId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", taskId=" + this.getTaskId() + ", parentTaskRunId=" + this.getParentTaskRunId() + ", value=" + this.getValue() + ", attempts=" + String.valueOf(this.getAttempts()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", state=" + String.valueOf(this.getState()) + ", iteration=" + this.getIteration() + ", dynamic=" + this.getDynamic() + ", forceExecution=" + this.getForceExecution() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$iteration = this.getIteration();
        Integer other$iteration = other.getIteration();
        if (this$iteration == null ? other$iteration != null : !((Object)this$iteration).equals(other$iteration)) {
            return false;
        }
        Boolean this$dynamic = this.getDynamic();
        Boolean other$dynamic = other.getDynamic();
        if (this$dynamic == null ? other$dynamic != null : !((Object)this$dynamic).equals(other$dynamic)) {
            return false;
        }
        Boolean this$forceExecution = this.getForceExecution();
        Boolean other$forceExecution = other.getForceExecution();
        if (this$forceExecution == null ? other$forceExecution != null : !((Object)this$forceExecution).equals(other$forceExecution)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$parentTaskRunId = this.getParentTaskRunId();
        String other$parentTaskRunId = other.getParentTaskRunId();
        if (this$parentTaskRunId == null ? other$parentTaskRunId != null : !this$parentTaskRunId.equals(other$parentTaskRunId)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<TaskRunAttempt> this$attempts = this.getAttempts();
        List<TaskRunAttempt> other$attempts = other.getAttempts();
        if (this$attempts == null ? other$attempts != null : !((Object)this$attempts).equals(other$attempts)) {
            return false;
        }
        Variables this$outputs = this.getOutputs();
        Variables other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskRun;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $iteration = this.getIteration();
        result = result * 59 + ($iteration == null ? 43 : ((Object)$iteration).hashCode());
        Boolean $dynamic = this.getDynamic();
        result = result * 59 + ($dynamic == null ? 43 : ((Object)$dynamic).hashCode());
        Boolean $forceExecution = this.getForceExecution();
        result = result * 59 + ($forceExecution == null ? 43 : ((Object)$forceExecution).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $parentTaskRunId = this.getParentTaskRunId();
        result = result * 59 + ($parentTaskRunId == null ? 43 : $parentTaskRunId.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<TaskRunAttempt> $attempts = this.getAttempts();
        result = result * 59 + ($attempts == null ? 43 : ((Object)$attempts).hashCode());
        Variables $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "id", "executionId", "namespace", "flowId", "taskId", "parentTaskRunId", "value", "attempts", "outputs", "state", "iteration", "dynamic", "forceExecution"})
    @Generated
    public TaskRun(String tenantId, String id, String executionId, String namespace, String flowId, String taskId, String parentTaskRunId, String value, List<TaskRunAttempt> attempts, @Nullable Variables outputs, State state, Integer iteration, Boolean dynamic, Boolean forceExecution) {
        this.tenantId = tenantId;
        this.id = id;
        this.executionId = executionId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.taskId = taskId;
        this.parentTaskRunId = parentTaskRunId;
        this.value = value;
        this.attempts = attempts;
        this.outputs = outputs;
        this.state = state;
        this.iteration = iteration;
        this.dynamic = dynamic;
        this.forceExecution = forceExecution;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getParentTaskRunId() {
        return this.parentTaskRunId;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public List<TaskRunAttempt> getAttempts() {
        return this.attempts;
    }

    @Nullable
    @Generated
    public Variables getOutputs() {
        return this.outputs;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public Integer getIteration() {
        return this.iteration;
    }

    @Generated
    public Boolean getDynamic() {
        return this.dynamic;
    }

    @Generated
    public Boolean getForceExecution() {
        return this.forceExecution;
    }

    @Generated
    public TaskRun withValue(String value) {
        return this.value == value ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, value, this.attempts, this.outputs, this.state, this.iteration, this.dynamic, this.forceExecution);
    }

    @Generated
    public TaskRun withAttempts(List<TaskRunAttempt> attempts) {
        return this.attempts == attempts ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, attempts, this.outputs, this.state, this.iteration, this.dynamic, this.forceExecution);
    }

    @Generated
    public TaskRun withOutputs(@Nullable Variables outputs) {
        return this.outputs == outputs ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, outputs, this.state, this.iteration, this.dynamic, this.forceExecution);
    }

    @Generated
    public TaskRun withIteration(Integer iteration) {
        return this.iteration == iteration ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state, iteration, this.dynamic, this.forceExecution);
    }

    @Generated
    public TaskRun withDynamic(Boolean dynamic) {
        return this.dynamic == dynamic ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state, this.iteration, dynamic, this.forceExecution);
    }

    @Generated
    public TaskRun withForceExecution(Boolean forceExecution) {
        return this.forceExecution == forceExecution ? this : new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state, this.iteration, this.dynamic, forceExecution);
    }

    @Generated
    public static class TaskRunBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String id;
        @Generated
        private String executionId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String taskId;
        @Generated
        private String parentTaskRunId;
        @Generated
        private String value;
        @Generated
        private List<TaskRunAttempt> attempts;
        @Generated
        private Variables outputs;
        @Generated
        private State state;
        @Generated
        private Integer iteration;
        @Generated
        private Boolean dynamic;
        @Generated
        private Boolean forceExecution;

        @Generated
        TaskRunBuilder() {
        }

        @Generated
        public TaskRunBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public TaskRunBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TaskRunBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public TaskRunBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public TaskRunBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public TaskRunBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public TaskRunBuilder parentTaskRunId(String parentTaskRunId) {
            this.parentTaskRunId = parentTaskRunId;
            return this;
        }

        @Generated
        public TaskRunBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public TaskRunBuilder attempts(List<TaskRunAttempt> attempts) {
            this.attempts = attempts;
            return this;
        }

        @Generated
        public TaskRunBuilder outputs(@Nullable Variables outputs) {
            this.outputs = outputs;
            return this;
        }

        @Generated
        public TaskRunBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public TaskRunBuilder iteration(Integer iteration) {
            this.iteration = iteration;
            return this;
        }

        @Generated
        public TaskRunBuilder dynamic(Boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        @Generated
        public TaskRunBuilder forceExecution(Boolean forceExecution) {
            this.forceExecution = forceExecution;
            return this;
        }

        @Generated
        public TaskRun build() {
            return new TaskRun(this.tenantId, this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state, this.iteration, this.dynamic, this.forceExecution);
        }

        @Generated
        public String toString() {
            return "TaskRun.TaskRunBuilder(tenantId=" + this.tenantId + ", id=" + this.id + ", executionId=" + this.executionId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", taskId=" + this.taskId + ", parentTaskRunId=" + this.parentTaskRunId + ", value=" + this.value + ", attempts=" + String.valueOf(this.attempts) + ", outputs=" + String.valueOf(this.outputs) + ", state=" + String.valueOf(this.state) + ", iteration=" + this.iteration + ", dynamic=" + this.dynamic + ", forceExecution=" + this.forceExecution + ")";
        }
    }
}

