/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions.metrics;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.AbstractMetricEntry;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import lombok.Generated;

public class Gauge
extends AbstractMetricEntry<Double> {
    public static final String TYPE = "gauge";
    @NotNull
    @JsonInclude
    private final String type = "gauge";
    @NotNull
    private Double value;

    private Gauge(@NotNull String name, @Nullable String description, @NotNull Double value, String ... tags) {
        super(name, description, tags);
        this.value = value;
    }

    public static Gauge of(@NotNull String name, @NotNull Double value, String ... tags) {
        return new Gauge(name, null, value, tags);
    }

    public static Gauge of(@NotNull String name, @Nullable String description, @NotNull Double value, String ... tags) {
        return new Gauge(name, description, value, tags);
    }

    public static Gauge of(@NotNull String name, @NotNull Integer value, String ... tags) {
        return new Gauge(name, null, (double)value, tags);
    }

    public static Gauge of(@NotNull String name, @Nullable String description, @NotNull Integer value, String ... tags) {
        return new Gauge(name, description, (double)value, tags);
    }

    public static Gauge of(@NotNull String name, @NotNull Long value, String ... tags) {
        return new Gauge(name, null, (double)value, tags);
    }

    public static Gauge of(@NotNull String name, @Nullable String description, @NotNull Long value, String ... tags) {
        return new Gauge(name, description, (double)value, tags);
    }

    public static Gauge of(@NotNull String name, @NotNull Float value, String ... tags) {
        return new Gauge(name, null, Double.valueOf(value.floatValue()), tags);
    }

    public static Gauge of(@NotNull String name, @Nullable String description, @NotNull Float value, String ... tags) {
        return new Gauge(name, description, Double.valueOf(value.floatValue()), tags);
    }

    @Override
    public void register(MetricRegistry meterRegistry, String name, String description, Map<String, String> tags) {
        meterRegistry.gauge(this.metricName(name), description, this.value, this.tagsAsArray(tags));
    }

    @Override
    public void increment(Double value) {
        this.value = value;
    }

    @Override
    @Generated
    public String toString() {
        return "Gauge(super=" + super.toString() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gauge)) {
            return false;
        }
        Gauge other = (Gauge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Gauge;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public Gauge() {
    }
}

