/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.validations.Regex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;
import lombok.Generated;

public class SecretInput
extends Input<String> {
    @Schema(title="Regular expression validating the value.")
    @Regex
    String validator;

    @Override
    public void validate(String input) throws ConstraintViolationException {
        if (this.validator != null && !Pattern.matches(this.validator, input)) {
            throw ManualConstraintViolation.toConstraintViolationException("it must match the pattern `" + this.validator + "`", this, SecretInput.class, this.getId(), input);
        }
    }

    @Generated
    protected SecretInput(SecretInputBuilder<?, ?> b) {
        super(b);
        this.validator = b.validator;
    }

    @Generated
    public static SecretInputBuilder<?, ?> builder() {
        return new SecretInputBuilderImpl();
    }

    @Generated
    public String getValidator() {
        return this.validator;
    }

    @Generated
    public SecretInput() {
    }

    @Generated
    public static abstract class SecretInputBuilder<C extends SecretInput, B extends SecretInputBuilder<C, B>>
    extends Input.InputBuilder<String, C, B> {
        @Generated
        private String validator;

        @Generated
        public B validator(String validator) {
            this.validator = validator;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SecretInput.SecretInputBuilder(super=" + super.toString() + ", validator=" + this.validator + ")";
        }
    }

    @Generated
    private static final class SecretInputBuilderImpl
    extends SecretInputBuilder<SecretInput, SecretInputBuilderImpl> {
        @Generated
        private SecretInputBuilderImpl() {
        }

        @Override
        @Generated
        protected SecretInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SecretInput build() {
            return new SecretInput(this);
        }
    }
}

