/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.sla.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.sla.ExecutionMonitoringSLA;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.runners.RunContext;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import lombok.Generated;

public class MaxDurationSLA
extends SLA
implements ExecutionMonitoringSLA {
    @NotNull
    private Duration duration;

    @Override
    public Optional<Violation> evaluate(RunContext runContext, Execution execution) throws InternalException {
        Duration executionDuration = Duration.between(execution.getState().getStartDate(), Instant.now());
        if (executionDuration.compareTo(this.getDuration()) > 0) {
            String reason = "execution duration of " + String.valueOf(executionDuration.truncatedTo(ChronoUnit.MILLIS)) + " exceed the maximum duration of " + String.valueOf(this.getDuration()) + ".";
            return Optional.of(new Violation(this.getId(), this.getBehavior(), this.getLabels(), reason));
        }
        return Optional.empty();
    }

    @Generated
    protected MaxDurationSLA(MaxDurationSLABuilder<?, ?> b) {
        super(b);
        this.duration = b.duration;
    }

    @Generated
    public static MaxDurationSLABuilder<?, ?> builder() {
        return new MaxDurationSLABuilderImpl();
    }

    @Override
    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public MaxDurationSLA() {
    }

    @Generated
    public static abstract class MaxDurationSLABuilder<C extends MaxDurationSLA, B extends MaxDurationSLABuilder<C, B>>
    extends SLA.SLABuilder<C, B> {
        @Generated
        private Duration duration;

        @Generated
        public B duration(Duration duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MaxDurationSLA.MaxDurationSLABuilder(super=" + super.toString() + ", duration=" + String.valueOf(this.duration) + ")";
        }
    }

    @Generated
    private static final class MaxDurationSLABuilderImpl
    extends MaxDurationSLABuilder<MaxDurationSLA, MaxDurationSLABuilderImpl> {
        @Generated
        private MaxDurationSLABuilderImpl() {
        }

        @Override
        @Generated
        protected MaxDurationSLABuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MaxDurationSLA build() {
            return new MaxDurationSLA(this);
        }
    }
}

