/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;

public interface FlowableTask<T extends Output> {
    @Schema(title="List of tasks to run if any tasks failed on this FlowableTask.")
    @PluginProperty
    public List<Task> getErrors();

    @Schema(title="List of tasks to run after any tasks failed or success on this FlowableTask.")
    @PluginProperty
    public List<Task> getFinally();

    public AbstractGraph tasksTree(Execution var1, TaskRun var2, List<String> var3) throws IllegalVariableEvaluationException;

    public List<Task> allChildTasks();

    public List<ResolvedTask> childTasks(RunContext var1, TaskRun var2) throws IllegalVariableEvaluationException;

    public List<NextTaskRun> resolveNexts(RunContext var1, Execution var2, TaskRun var3) throws IllegalVariableEvaluationException;

    public boolean isAllowFailure();

    public boolean isAllowWarning();

    default public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    default public T outputs(RunContext runContext) throws Exception {
        return null;
    }
}

