/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Cache;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.TaskInterface;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.flow.WorkingDirectory;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.event.Level;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Plugin
public abstract class Task
implements TaskInterface {
    @Size(max=256, message="Task id must be at most 256 characters")
    protected @Size(max=256, message="Task id must be at most 256 characters") String id;
    protected String type;
    @PluginProperty(hidden=true, group="core")
    protected String version;
    @PluginProperty(hidden=true, group="core")
    private String description;
    @Valid
    @PluginProperty(hidden=true, group="core")
    protected AbstractRetry retry;
    @PluginProperty(hidden=true, group="core")
    protected Property<Duration> timeout;
    @PluginProperty(hidden=true, group="core")
    protected Boolean disabled;
    @Valid
    @PluginProperty(hidden=true, group="core")
    private WorkerGroup workerGroup;
    @PluginProperty(hidden=true, group="core")
    private Level logLevel;
    @PluginProperty(hidden=true, group="core")
    private boolean allowFailure;
    @PluginProperty(hidden=true, group="core")
    private boolean logToFile;
    @PluginProperty(hidden=true, group="core")
    private String runIf;
    @PluginProperty(hidden=true, group="core")
    private boolean allowWarning;
    @PluginProperty(hidden=true, group="core")
    @Valid
    private Cache taskCache;

    public Optional<Task> findById(String id) {
        Optional<Task> childs;
        if (this.getId().equals(id)) {
            return Optional.of(this);
        }
        if (this.isFlowable() && (childs = ((FlowableTask)((Object)this)).allChildTasks().stream().map(t -> t.findById(id)).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return childs;
        }
        return Optional.empty();
    }

    public Optional<Task> findById(String id, RunContext runContext, TaskRun taskRun) throws IllegalVariableEvaluationException {
        Optional<Task> errorChilds;
        Optional<Task> childs;
        if (this.getId().equals(id)) {
            return Optional.of(this);
        }
        if (this.isFlowable() && (childs = ((FlowableTask)((Object)this)).childTasks(runContext, taskRun).stream().map(Rethrow.throwFunction(resolvedTask -> resolvedTask.getTask().findById(id, runContext, taskRun))).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return childs;
        }
        if (this.isFlowable() && ((FlowableTask)((Object)this)).getErrors() != null && (errorChilds = ((FlowableTask)((Object)this)).getErrors().stream().map(Rethrow.throwFunction(task -> task.findById(id, runContext, taskRun))).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return errorChilds;
        }
        return Optional.empty();
    }

    @JsonIgnore
    public boolean isFlowable() {
        return this instanceof FlowableTask;
    }

    @JsonIgnore
    public boolean isSendToWorkerTask() {
        return !(this instanceof FlowableTask) || this instanceof WorkingDirectory;
    }

    @Generated
    private static Boolean $default$disabled() {
        return false;
    }

    @Generated
    private static boolean $default$allowFailure() {
        return false;
    }

    @Generated
    private static boolean $default$logToFile() {
        return false;
    }

    @Generated
    private static String $default$runIf() {
        return "true";
    }

    @Generated
    private static boolean $default$allowWarning() {
        return false;
    }

    @Generated
    protected Task(TaskBuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.version = b.version;
        this.description = b.description;
        this.retry = b.retry;
        this.timeout = b.timeout;
        this.disabled = b.disabled$set ? b.disabled$value : Task.$default$disabled();
        this.workerGroup = b.workerGroup;
        this.logLevel = b.logLevel;
        this.allowFailure = b.allowFailure$set ? b.allowFailure$value : Task.$default$allowFailure();
        this.logToFile = b.logToFile$set ? b.logToFile$value : Task.$default$logToFile();
        this.runIf = b.runIf$set ? b.runIf$value : Task.$default$runIf();
        this.allowWarning = b.allowWarning$set ? b.allowWarning$value : Task.$default$allowWarning();
        this.taskCache = b.taskCache;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public AbstractRetry getRetry() {
        return this.retry;
    }

    @Generated
    public Property<Duration> getTimeout() {
        return this.timeout;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public boolean isAllowFailure() {
        return this.allowFailure;
    }

    @Generated
    public boolean isLogToFile() {
        return this.logToFile;
    }

    @Generated
    public String getRunIf() {
        return this.runIf;
    }

    @Generated
    public boolean isAllowWarning() {
        return this.allowWarning;
    }

    @Generated
    public Cache getTaskCache() {
        return this.taskCache;
    }

    @Generated
    public Task() {
        this.disabled = Task.$default$disabled();
        this.allowFailure = Task.$default$allowFailure();
        this.logToFile = Task.$default$logToFile();
        this.runIf = Task.$default$runIf();
        this.allowWarning = Task.$default$allowWarning();
    }

    @Generated
    public static abstract class TaskBuilder<C extends Task, B extends TaskBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private AbstractRetry retry;
        @Generated
        private Property<Duration> timeout;
        @Generated
        private boolean disabled$set;
        @Generated
        private Boolean disabled$value;
        @Generated
        private WorkerGroup workerGroup;
        @Generated
        private Level logLevel;
        @Generated
        private boolean allowFailure$set;
        @Generated
        private boolean allowFailure$value;
        @Generated
        private boolean logToFile$set;
        @Generated
        private boolean logToFile$value;
        @Generated
        private boolean runIf$set;
        @Generated
        private String runIf$value;
        @Generated
        private boolean allowWarning$set;
        @Generated
        private boolean allowWarning$value;
        @Generated
        private Cache taskCache;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Task instance, TaskBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.version(instance.version);
            b.description(instance.description);
            b.retry(instance.retry);
            b.timeout(instance.timeout);
            b.disabled(instance.disabled);
            b.workerGroup(instance.workerGroup);
            b.logLevel(instance.logLevel);
            b.allowFailure(instance.allowFailure);
            b.logToFile(instance.logToFile);
            b.runIf(instance.runIf);
            b.allowWarning(instance.allowWarning);
            b.taskCache(instance.taskCache);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B retry(AbstractRetry retry) {
            this.retry = retry;
            return this.self();
        }

        @Generated
        public B timeout(Property<Duration> timeout) {
            this.timeout = timeout;
            return this.self();
        }

        @Generated
        public B disabled(Boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B workerGroup(WorkerGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this.self();
        }

        @Generated
        public B logLevel(Level logLevel) {
            this.logLevel = logLevel;
            return this.self();
        }

        @Generated
        public B allowFailure(boolean allowFailure) {
            this.allowFailure$value = allowFailure;
            this.allowFailure$set = true;
            return this.self();
        }

        @Generated
        public B logToFile(boolean logToFile) {
            this.logToFile$value = logToFile;
            this.logToFile$set = true;
            return this.self();
        }

        @Generated
        public B runIf(String runIf) {
            this.runIf$value = runIf;
            this.runIf$set = true;
            return this.self();
        }

        @Generated
        public B allowWarning(boolean allowWarning) {
            this.allowWarning$value = allowWarning;
            this.allowWarning$set = true;
            return this.self();
        }

        @Generated
        public B taskCache(Cache taskCache) {
            this.taskCache = taskCache;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", type=" + this.type + ", version=" + this.version + ", description=" + this.description + ", retry=" + String.valueOf(this.retry) + ", timeout=" + String.valueOf(this.timeout) + ", disabled$value=" + this.disabled$value + ", workerGroup=" + String.valueOf(this.workerGroup) + ", logLevel=" + String.valueOf(this.logLevel) + ", allowFailure$value=" + this.allowFailure$value + ", logToFile$value=" + this.logToFile$value + ", runIf$value=" + this.runIf$value + ", allowWarning$value=" + this.allowWarning$value + ", taskCache=" + String.valueOf(this.taskCache) + ")";
        }
    }
}

