/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.metrics;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Gauge;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.metrics.AbstractMetric;
import io.kestra.core.runners.RunContext;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class GaugeMetric
extends AbstractMetric {
    public static final String TYPE = "gauge";
    @NotNull
    private Property<Double> value;

    @Override
    public AbstractMetricEntry<?> toMetric(RunContext runContext) throws IllegalVariableEvaluationException {
        String name = runContext.render(this.name).as(String.class).orElseThrow();
        Double value = runContext.render(this.value).as(Double.class).orElseThrow();
        String description = runContext.render(this.description).as(String.class).orElse(null);
        Map tags = (Map)runContext.render(this.tags).asMap(String.class, String.class);
        String[] tagsAsStrings = (String[])tags.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new);
        return Gauge.of(name, description, value, tagsAsStrings);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Generated
    protected GaugeMetric(GaugeMetricBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
    }

    @Generated
    public static GaugeMetricBuilder<?, ?> builder() {
        return new GaugeMetricBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "GaugeMetric(super=" + super.toString() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GaugeMetric)) {
            return false;
        }
        GaugeMetric other = (GaugeMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GaugeMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Property<Double> getValue() {
        return this.value;
    }

    @Generated
    public GaugeMetric() {
    }

    @ConstructorProperties(value={"value"})
    @Generated
    public GaugeMetric(Property<Double> value) {
        this.value = value;
    }

    @Generated
    public static abstract class GaugeMetricBuilder<C extends GaugeMetric, B extends GaugeMetricBuilder<C, B>>
    extends AbstractMetric.AbstractMetricBuilder<C, B> {
        @Generated
        private Property<Double> value;

        @Generated
        public B value(Property<Double> value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GaugeMetric.GaugeMetricBuilder(super=" + super.toString() + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    @Generated
    private static final class GaugeMetricBuilderImpl
    extends GaugeMetricBuilder<GaugeMetric, GaugeMetricBuilderImpl> {
        @Generated
        private GaugeMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected GaugeMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GaugeMetric build() {
            return new GaugeMetric(this);
        }
    }
}

