/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.retrys;

import com.fasterxml.jackson.annotation.JsonInclude;
import dev.failsafe.RetryPolicyBuilder;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.validations.RandomRetryValidation;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@RandomRetryValidation
public class Random
extends AbstractRetry {
    @NotNull
    @JsonInclude
    protected String type;
    @NotNull
    private Duration minInterval;
    @NotNull
    private Duration maxInterval;

    @Override
    public <T> RetryPolicyBuilder<T> toPolicy() {
        RetryPolicyBuilder policy = super.toPolicy();
        return policy.withDelay(this.minInterval.toMillis(), this.maxInterval.toMillis(), ChronoUnit.MILLIS);
    }

    @Override
    public Instant nextRetryDate(Integer attemptCount, Instant lastAttempt) {
        java.util.Random random = new java.util.Random();
        long randomMillis = random.nextLong(this.minInterval.toMillis(), this.maxInterval.toMillis());
        return lastAttempt.plusMillis(randomMillis);
    }

    @Generated
    private static String $default$type() {
        return "random";
    }

    @Generated
    protected Random(RandomBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : Random.$default$type();
        this.minInterval = b.minInterval;
        this.maxInterval = b.maxInterval;
    }

    @Generated
    public static RandomBuilder<?, ?> builder() {
        return new RandomBuilderImpl();
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Duration getMinInterval() {
        return this.minInterval;
    }

    @Generated
    public Duration getMaxInterval() {
        return this.maxInterval;
    }

    @Generated
    public Random() {
        this.type = Random.$default$type();
    }

    @Generated
    public static abstract class RandomBuilder<C extends Random, B extends RandomBuilder<C, B>>
    extends AbstractRetry.AbstractRetryBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private Duration minInterval;
        @Generated
        private Duration maxInterval;

        @Generated
        public B type(String type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B minInterval(Duration minInterval) {
            this.minInterval = minInterval;
            return (B)this.self();
        }

        @Generated
        public B maxInterval(Duration maxInterval) {
            this.maxInterval = maxInterval;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Random.RandomBuilder(super=" + super.toString() + ", type$value=" + this.type$value + ", minInterval=" + String.valueOf(this.minInterval) + ", maxInterval=" + String.valueOf(this.maxInterval) + ")";
        }
    }

    @Generated
    private static final class RandomBuilderImpl
    extends RandomBuilder<Random, RandomBuilderImpl> {
        @Generated
        private RandomBuilderImpl() {
        }

        @Override
        @Generated
        protected RandomBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Random build() {
            return new Random(this);
        }
    }
}

